<?php

namespace App\Helpers;

use App\Models\Role;
use Illuminate\Support\Facades\Cache;

class RoleHelper
{
    /**
     * Get role ID by name
     */
    public static function getRoleId(string $roleName): ?int
    {
        $role = Role::where('name', $roleName)->where('status', true)->first();
        return $role ? $role->id : null;
    }

    /**
     * Get admin role ID
     */
    public static function getAdminRoleId(): ?int
    {
        return self::getRoleId('admin');
    }

    /**
     * Get user role ID
     */
    public static function getUserRoleId(): ?int
    {
        return self::getRoleId('user');
    }

    /**
     * Clear role cache
     */
    public static function clearCache(): void
    {
        Cache::forget('roles_cache');
    }
}