<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Services\ApiLogService;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function toggleApiLogging(Request $request)
    {
        $request->validate([
            'logs' => 'required|boolean'
        ]);

        $setting = Setting::firstOrCreate([]);
        $setting->update(['logs' => $request->logs]);

        // Clear cache to immediately apply changes
        ApiLogService::clearCache();

        return response()->json([
            'status' => true,
            'message' => 'API logging ' . ($request->logs ? 'enabled' : 'disabled') . ' successfully',
            'logs_enabled' => (bool)$request->logs
        ]);
    }

    public function getApiLoggingStatus()
    {
        $setting = Setting::first();
        $logsEnabled = $setting ? (bool)$setting->logs : true;

        return response()->json([
            'status' => true,
            'logs_enabled' => $logsEnabled
        ]);
    }
}