<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class CustomerController extends Controller
{
    public function index()
    {
        $customers = Customer::paginate(10);
        return view('admin.customer.index', compact('customers'));
    }

    public function create()
    {
        return view('admin.customer.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'customer_name' => 'required|string|max:255',
            'firm_name' => 'nullable|string|max:255',
            'contact_number' => 'required|string|max:20',
            'email' => 'required|email|unique:customers,email',
            'address' => 'required|string',
            'gst_number' => 'nullable|string|max:15',
        ]);

        Customer::create($request->all());

        return redirect()->route('customer.create')->with('success', 'Customer created successfully!');
    }

    public function edit(Customer $customer)
    {
        return view('admin.customer.edit', compact('customer'));
    }

    public function update(Request $request, Customer $customer)
    {
        $request->validate([
            'customer_name' => 'required|string|max:255',
            'firm_name' => 'nullable|string|max:255',
            'contact_number' => 'required|string|max:20',
            'email' => ['required', 'email', Rule::unique('customers')->ignore($customer->id)],
            'address' => 'required|string',
            'gst_number' => 'nullable|string|max:15',
        ]);

        $customer->update($request->all());

        return redirect()->route('customer.index')->with('success', 'Customer updated successfully!');
    }

    public function destroy(Customer $customer)
    {
        $customer->delete();
        return redirect()->route('customer.index')->with('success', 'Customer deleted successfully!');
    }
}