<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;

class SettingController extends Controller
{
    public function index()
    {
        try {
            $setting = Setting::first() ?? new Setting();
            return view('admin.settings.index', compact('setting'));
        } catch (\Exception $e) {
            Log::error('Error in SettingController@index: ' . $e->getMessage());
            return redirect()->back()->with('error', 'An error occurred while fetching settings.');
        }
    }

    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'support_number1' => 'nullable|string|max:20',
                'support_number2' => 'nullable|string|max:20',
                'version' => 'nullable|string|max:50',
                'logs' => 'nullable|string',
                'status3' => 'nullable|string|max:100',
                'status4' => 'nullable|string|max:100',
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $data = $request->only(['support_number1', 'support_number2', 'version', 'logs', 'status3', 'status4', 'maintenance_mode', 'maintenance_mode_web']);

            $setting = Setting::first();
            if ($setting) {
                $setting->update($data);
            } else {
                Setting::create($data);
            }

            return redirect()->route('settings.index')->with('success', 'Settings updated successfully');
        } catch (\Exception $e) {
            Log::error('Error in SettingController@store: ' . $e->getMessage());
            return redirect()->back()->with('error', 'An error occurred while updating settings.');
        }
    }
}