<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class CheckRoutePermission
{
    // public function handle(Request $request, Closure $next)
    // {
    //     try {
    //         $user = auth()->user();

    //         if (!$user) {
    //             return redirect()->route('login');
    //         }

    //         $currentRoute = $request->route()->getName();

    //         if (!$user->hasRoutePermission($currentRoute)) {
    //             return response()->view('errors.permission-denied', [], 403);
    //         }

    //         return $next($request);
    //     } catch (\Exception $e) {
    //         Log::error('Route permission check error: ' . $e->getMessage());
    //         return response()->view('errors.permission-denied', [], 403);
    //     }
    // }

    public function handle(Request $request, Closure $next)
    {
        try {
            $user = auth()->user();

            // Not logged in
            if (!$user) {
                return redirect()->route('login');
            }

            //  Admin role → allow all routes
            if ((int) $user->role_id === 1) {
                return $next($request);
            }

            // Current route name
            $currentRoute = $request->route()?->getName();

            // If route has no name, allow
            if (!$currentRoute) {
                return $next($request);
            }

            // Check permission
            if (!$user->hasRoutePermission($currentRoute)) {
                return response()->view('errors.permission-denied', [], 403);
            }

            return $next($request);
        } catch (\Exception $e) {
            Log::error('Route permission check error: ' . $e->getMessage());
            return response()->view('errors.permission-denied', [], 403);
        }
    }
}
