<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RejectQueryString
{
    public function handle(Request $request, Closure $next)
    {
        if (!empty($request->query())) {
            return response()->json([
                'error' => 'Query parameters are not allowed. Please send data in request body.'
            ], 400);
        }

        return $next($request);
    }
}