<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Applicant extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'segment',
        'loan_type',
        'customer_type',
        'applicant_first_name',
        'applicant_middle_name',
        'applicant_last_name',
        'father_name',
        'caste',
        'dob',
        'age',
        'gender',
        'contact_number',
        'contact_verified',
        'address_type',
        'current_address',
        'current_city',
        'current_state',
        'current_pincode',
        'place_of_birth',
        'nationality',
        'marital_status',
        'spouse_name',
        'email',
        'email_verified',
        'pan',
        'pan_verified',
        'aadhaar',
        'aadhaar_verified',
        'voter_id',
        'voter_id_verified',
        'driving_license',
        'driving_license_verified',
        'passport',
        'form_60',
        'banking_info',
        'reference_1',
        'reference_1_relation_id',
        'reference_2',
        'reference_2_relation_id',
        'login_date',
        'login_amount',
        'tenure',
        'roi',
        'bm_name_id',
        'rm_name',
        'branch_name',
        'bt_yes_no_id',
        'bt_company_name',
        'imd_waiver',
        'imd_transaction_ref',
        'business_address',
        'annual_income',
        'obligation',
        'foir',
        'ltv',
        'gps_tagging',
        'property_address',
        'property_type',
        'property_owner_name',
        'psl_yes_no_id',
        'manufacturing_service_agriculture',
        'psl_sub_category',
        'purpose_of_loans',
        'psl_document_type',
        'psl_document_number',
        'field_investigation_flag',
        'tele_verification_flag',
        'personal_discussion_flag',
        'status',
        'created_by',
        'assign_to',
        'assign_date',
        'assigned_by',
        'branch_id',
        'remark',
        'applicant_image'
    ];

    protected $casts = [
        'dob' => 'date',
        'login_date' => 'date',
        'assign_date' => 'datetime',
        'login_amount' => 'decimal:2',
        'roi' => 'decimal:2',
        'annual_income' => 'decimal:2',
        'obligation' => 'decimal:2',
        'foir' => 'decimal:2',
        'ltv' => 'decimal:2',
        'contact_verified' => 'boolean',
        'email_verified' => 'boolean',
        'pan_verified' => 'boolean',
        'aadhaar_verified' => 'boolean',
        'voter_id_verified' => 'boolean',
        'driving_license_verified' => 'boolean',
        'form_60' => 'boolean',
        'field_investigation_flag' => 'boolean',
        'tele_verification_flag' => 'boolean',
        'personal_discussion_flag' => 'boolean',
    ];

    // User relationships
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assign_to');
    }

    public function assignedBy()
    {
        return $this->belongsTo(User::class, 'assigned_by');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }

    // FormField relationships for dropdown options
    public function segment()
    {
        return $this->belongsTo(FormFieldOption::class, 'segment');
    }

    public function loanType()
    {
        return $this->belongsTo(FormFieldOption::class, 'loan_type');
    }

    public function customerType()
    {
        return $this->belongsTo(FormFieldOption::class, 'customer_type');
    }

    public function caste()
    {
        return $this->belongsTo(FormFieldOption::class, 'caste');
    }

    public function gender()
    {
        return $this->belongsTo(FormFieldOption::class, 'gender');
    }

    public function addressType()
    {
        return $this->belongsTo(FormFieldOption::class, 'address_type');
    }

    public function maritalStatus()
    {
        return $this->belongsTo(FormFieldOption::class, 'marital_status');
    }

    public function bankingInfo()
    {
        return $this->belongsTo(FormFieldOption::class, 'banking_info');
    }

    public function tenure()
    {
        return $this->belongsTo(FormFieldOption::class, 'tenure');
    }

    public function imdWaiver()
    {
        return $this->belongsTo(FormFieldOption::class, 'imd_waiver');
    }

    public function propertyType()
    {
        return $this->belongsTo(FormFieldOption::class, 'property_type');
    }

    public function manufacturingServiceAgriculture()
    {
        return $this->belongsTo(FormFieldOption::class, 'manufacturing_service_agriculture');
    }

    public function pslSubCategory()
    {
        return $this->belongsTo(FormFieldOption::class, 'psl_sub_category');
    }

    public function purposeOfLoans()
    {
        return $this->belongsTo(FormFieldOption::class, 'purpose_of_loans');
    }

    public function pslDocumentType()
    {
        return $this->belongsTo(FormFieldOption::class, 'psl_document_type');
    }

    // Relationship to CoApplicants
    public function coApplicants()
    {
        return $this->hasMany(CoApplicant::class);
    }

    // Relationship to ApplicantGuarantors
    public function guarantors()
    {
        return $this->hasMany(ApplicantGuarantor::class);
    }

    // Relationship to ApplicantReferences
    public function references()
    {
        return $this->hasMany(ApplicantReference::class);
    }

}