<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantLeadStatusLog extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'applicant_lead_id',
        'lead_status',
        'action_by',
        'action_date',
        'remark'
    ];

    protected $casts = [
        'action_date' => 'datetime'
    ];

    public function applicant()
    {
        return $this->belongsTo(Applicant::class, 'applicant_lead_id');
    }

    public function actionBy()
    {
        return $this->belongsTo(User::class, 'action_by');
    }
}
