<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ApplicantReference extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'applicant_id',
        'name',
        'contact_no',
        'relation_with_applicant',
        'status'
    ];

    public function applicant()
    {
        return $this->belongsTo(Applicant::class);
    }

    public function relationWithApplicant()
    {
        return $this->belongsTo(FormFieldOption::class, 'relation_with_applicant');
    }
}