<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class District extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'state_id',
        'status',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    /**
     * Get the state that owns the district
     */
    public function state()
    {
        return $this->belongsTo(State::class);
    }

    /**
     * Get the cities for the district
     */
    public function cities()
    {
        return $this->hasMany(City::class);
    }
}