<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'status',
        'priority',
    ];

    protected $casts = [
        'priority' => 'integer',
        'status' => 'integer',
    ];

    /**
     * Get all sub menus for this menu
     * Relationship: One Menu has Many SubMenus
     */
    public function subMenus()
    {
        return $this->hasMany(SubMenu::class);
    }
}