<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubMenu extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'menu_id',
        'parent_id',
        'name',
        'route',
        'priority',
        'status',
    ];

    protected $casts = [
        'priority' => 'integer',
        'status' => 'integer'
    ];

    /**
     * Get the menu that owns this sub menu
     * Relationship: Each SubMenu belongs to One Menu
     */
    public function menu()
    {
        return $this->belongsTo(Menu::class);
    }

    /**
     * Get the parent sub menu
     * Relationship: Each SubMenu can belong to One Parent SubMenu
     */
    public function parent()
    {
        return $this->belongsTo(SubMenu::class, 'parent_id');
    }

    /**
     * Get child sub menus
     * Relationship: One SubMenu can have Many Child SubMenus
     */
    public function children()
    {
        return $this->hasMany(SubMenu::class, 'parent_id');
    }
}