<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('api_logs', function (Blueprint $table) {
            $table->id();
            $table->string('log_type')->nullable();
            $table->string('endpoint')->nullable();
            $table->text('message')->nullable();
            $table->json('data')->nullable();
            $table->string('user_ip')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->json('device_info')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('api_logs');
    }
};