<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('identity_documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('document_id')->nullable();
            $table->foreignId('applicant_id')->constrained('applicants')->onDelete('cascade');
            $table->enum('document_type', ['PAN', 'AADHAAR', 'VOTER_ID', 'DRIVING_LICENSE', 'PASSPORT', 'FORM_60']);
            $table->string('document_number', 100);
            $table->enum('verified', ['Yes', 'No', 'Pending'])->default('Pending');
            $table->enum('verification_method', ['Manual', 'API', 'Not Required'])->nullable();
            $table->dateTime('verification_date')->nullable();
            $table->softDeletes();
            $table->timestamps();
            
            $table->unique(['applicant_id', 'document_type'], 'unique_document');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('identity_documents');
    }
};