<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('banking_info', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('banking_id')->nullable();
            $table->foreignId('applicant_id')->constrained('applicants')->onDelete('cascade');
            $table->enum('banking_type', ['Savings', 'Current', 'Salary'])->nullable();
            $table->string('reference_1', 200)->nullable();
            $table->string('relation_with_applicant', 100)->nullable();
            $table->string('reference_2', 200)->nullable();
            $table->string('reference_2_relation', 100)->nullable();
            $table->string('reference_3', 200)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('banking_info');
    }
};