<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            if (!Schema::hasColumn('settings', 'maintenance_mode_web')) {
                $table->boolean('maintenance_mode_web')->default(false)->after('logs');
            }
            if (!Schema::hasColumn('settings', 'status3')) {
                $table->string('status3')->nullable()->after('maintenance_mode_web');
            }
            if (!Schema::hasColumn('settings', 'status4')) {
                $table->string('status4')->nullable()->after('status3');
            }
        });
    }

    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn(['maintenance_mode_web', 'status3', 'status4']);
        });
    }
};