<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('applicants', function (Blueprint $table) {
            $table->id();
            
            // Basic Information
            $table->integer('segment_id')->nullable();
            $table->integer('customer_type_id')->nullable();
            $table->string('applicant_first_name')->nullable();
            $table->string('applicant_middle_name')->nullable();
            $table->string('applicant_last_name')->nullable();
            $table->string('father_name')->nullable();
            $table->integer('caste_id')->nullable();
            $table->date('dob')->nullable();
            $table->integer('age')->nullable();
            $table->integer('gender_id')->nullable();
            $table->string('contact_number')->nullable();
            $table->boolean('contact_verified')->default(false);
            
            // Address Information
            $table->integer('address_type_id')->nullable();
            $table->text('current_address')->nullable();
            $table->string('current_city')->nullable();
            $table->string('current_state')->nullable();
            $table->string('current_pincode')->nullable();
            $table->string('place_of_birth')->nullable();
            $table->string('nationality')->nullable();
            $table->integer('marital_status_id')->nullable();
            $table->string('spouse_name')->nullable();
            $table->string('email')->nullable();
            $table->boolean('email_verified')->default(false);
            
            // Identity Documents
            $table->string('pan')->nullable();
            $table->boolean('pan_verified')->default(false);
            $table->string('aadhaar')->nullable();
            $table->boolean('aadhaar_verified')->default(false);
            $table->string('voter_id')->nullable();
            $table->boolean('voter_id_verified')->default(false);
            $table->string('driving_license')->nullable();
            $table->boolean('driving_license_verified')->default(false);
            $table->string('passport')->nullable();
            $table->boolean('form_60')->default(false);
            
            // Banking and References
            $table->integer('banking_info_id')->nullable();
            $table->string('reference_1')->nullable();
            $table->integer('reference_1_relation_id')->nullable();
            $table->string('reference_2')->nullable();
            $table->integer('reference_2_relation_id')->nullable();
            
            // Loan Information
            $table->date('login_date')->nullable();
            $table->decimal('login_amount', 15, 2)->nullable();
            $table->integer('tenure_id')->nullable();
            $table->decimal('roi', 5, 2)->nullable();
            $table->integer('bm_name_id')->nullable();
            $table->string('rm_name')->nullable();
            $table->string('branch_name')->nullable();
            
            // BT and IMD Information
            $table->integer('bt_yes_no_id')->nullable();
            $table->string('bt_company_name')->nullable();
            $table->integer('imd_waiver_id')->nullable();
            $table->string('imd_transaction_ref')->nullable();
            
            // Business Information
            $table->text('business_address')->nullable();
            $table->decimal('annual_income', 15, 2)->nullable();
            $table->decimal('obligation', 15, 2)->nullable();
            $table->decimal('foir', 5, 2)->nullable();
            $table->decimal('ltv', 5, 2)->nullable();
            $table->string('gps_tagging')->nullable();
            
            // Property Information
            $table->text('property_address')->nullable();
            $table->integer('property_type_id')->nullable();
            $table->string('property_owner_name')->nullable();
            
            // PSL Information
            $table->integer('psl_yes_no_id')->nullable();
            $table->integer('manufacturing_service_agriculture_id')->nullable();
            $table->integer('psl_sub_category_id')->nullable();
            $table->integer('purpose_of_loans_id')->nullable();
            $table->integer('psl_document_type_id')->nullable();
            $table->string('psl_document_number')->nullable();
            
            // Verification Flags
            $table->boolean('field_investigation_flag')->nullable();
            $table->boolean('tele_verification_flag')->nullable();
            $table->boolean('personal_discussion_flag')->nullable();
            
            // System Fields
            $table->integer('status')->default(1);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('assign_to')->nullable();
            $table->unsignedBigInteger('assigned_by')->nullable();
            $table->text('remark')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            // Foreign key constraints
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('assign_to')->references('id')->on('users')->onDelete('set null');
            $table->foreign('assigned_by')->references('id')->on('users')->onDelete('set null');
            
            // Indexes
            $table->index('status');
            $table->index('created_by');
            $table->index('assign_to');
            $table->index('assigned_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('applicants');
    }
};