<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('applicants', function (Blueprint $table) {
            $table->renameColumn('segment_id', 'segment');
            $table->renameColumn('customer_type_id', 'customer_type');
            $table->renameColumn('caste_id', 'caste');
            $table->renameColumn('gender_id', 'gender');
            $table->renameColumn('address_type_id', 'address_type');
            $table->renameColumn('marital_status_id', 'marital_status');
            $table->renameColumn('banking_info_id', 'banking_info');
            $table->renameColumn('tenure_id', 'tenure');
            $table->renameColumn('imd_waiver_id', 'imd_waiver');
            $table->renameColumn('property_type_id', 'property_type');
            $table->renameColumn('psl_sub_category_id', 'psl_sub_category');
            $table->renameColumn('manufacturing_service_agriculture_id', 'manufacturing_service_agriculture');
            $table->renameColumn('purpose_of_loans_id', 'purpose_of_loans');
            $table->renameColumn('psl_document_type_id', 'psl_document_type');
        });
    }

    public function down()
    {
        Schema::table('applicants', function (Blueprint $table) {
            $table->renameColumn('segment', 'segment_id');
            $table->renameColumn('customer_type', 'customer_type_id');
            $table->renameColumn('caste', 'caste_id');
            $table->renameColumn('gender', 'gender_id');
            $table->renameColumn('address_type', 'address_type_id');
            $table->renameColumn('marital_status', 'marital_status_id');
            $table->renameColumn('banking_info', 'banking_info_id');
            $table->renameColumn('tenure', 'tenure_id');
            $table->renameColumn('imd_waiver', 'imd_waiver_id');
            $table->renameColumn('property_type', 'property_type_id');
            $table->renameColumn('psl_sub_category', 'psl_sub_category_id');
            $table->renameColumn('manufacturing_service_agriculture', 'manufacturing_service_agriculture_id');
            $table->renameColumn('purpose_of_loans', 'purpose_of_loans_id');
            $table->renameColumn('psl_document_type', 'psl_document_type_id');
        });
    }
};