<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('applicants', function (Blueprint $table) {
            $table->string('applicant_first_name')->nullable()->change();
            $table->string('applicant_last_name')->nullable()->change();
            $table->string('father_name')->nullable()->change();
            $table->string('contact_number')->nullable()->change();
            $table->text('current_address')->nullable()->change();
            $table->string('current_pincode')->nullable()->change();
            $table->string('place_of_birth')->nullable()->change();
            $table->string('nationality')->nullable()->change();
            $table->boolean('field_investigation_flag')->nullable()->change();
            $table->boolean('tele_verification_flag')->nullable()->change();
            $table->boolean('personal_discussion_flag')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('applicants', function (Blueprint $table) {
            $table->string('applicant_first_name')->nullable(false)->change();
            $table->string('applicant_last_name')->nullable(false)->change();
            $table->string('father_name')->nullable(false)->change();
            $table->string('contact_number')->nullable(false)->change();
            $table->text('current_address')->nullable(false)->change();
            $table->string('current_pincode')->nullable(false)->change();
            $table->string('place_of_birth')->nullable(false)->change();
            $table->string('nationality')->default('Indian')->change();
            $table->boolean('field_investigation_flag')->default(false)->change();
            $table->boolean('tele_verification_flag')->default(false)->change();
            $table->boolean('personal_discussion_flag')->default(false)->change();
        });
    }
};