<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('applicants', function (Blueprint $table) {
            $table->dropColumn([
                'reference_1',
                'reference_1_relation_id',
                'reference_2',
                'reference_2_relation_id',
                'branch_name'
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('applicants', function (Blueprint $table) {
            $table->string('reference_1')->nullable();
            $table->integer('reference_1_relation_id')->nullable();
            $table->string('reference_2')->nullable();
            $table->integer('reference_2_relation_id')->nullable();
            $table->string('branch_name')->nullable();
        });
    }
};