<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('product_name');
            $table->string('product_card_no')->unique();
            $table->unsignedBigInteger('co_design');
            $table->unsignedBigInteger('standard_size');
            $table->unsignedBigInteger('color');
            $table->unsignedBigInteger('collection');
            $table->unsignedBigInteger('shape');
            $table->unsignedBigInteger('style');
            $table->unsignedBigInteger('customer_design');
            $table->unsignedBigInteger('quality');
            $table->unsignedBigInteger('weave');
            $table->string('cad_photo')->nullable();
            $table->json('yarn_shade_data'); // Store yarn, shade, percentage, kilogram data
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
