<?php

namespace Database\Seeders;

use App\Models\Branch;
use App\Models\State;
use App\Models\District;
use App\Models\City;
use Illuminate\Database\Seeder;

class BranchSeeder extends Seeder
{
    public function run(): void
    {
        $state = State::first();
        $district = District::first();
        $city = City::first();

        if ($state && $district && $city) {
            $branches = [
                [
                    'branch_name' => 'Head Office',
                    'branch_code' => 'HO001',
                    'state_id' => $state->id,
                    'district_id' => $district->id,
                    'city_id' => $city->id,
                    'address' => 'Main Street, Business District',
                    'pincode' => '400001',
                    'is_head_branch' => true,
                    'status' => true,
                ],
                [
                    'branch_name' => 'Branch Office 1',
                    'branch_code' => 'BR001',
                    'state_id' => $state->id,
                    'district_id' => $district->id,
                    'city_id' => $city->id,
                    'address' => 'Commercial Area, Zone 1',
                    'pincode' => '400002',
                    'is_head_branch' => false,
                    'status' => true,
                ],
            ];

            foreach ($branches as $branch) {
                Branch::updateOrCreate(
                    ['branch_code' => $branch['branch_code']],
                    $branch
                );
            }
        }
    }
}