<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Menu;
use App\Models\SubMenu;

class SubMenuSeeder extends Seeder
{
    public function run(): void
    {
        // Get Masters menu
        $mastersMenu = Menu::where('name', 'Masters')->first();
        
        if ($mastersMenu) {
            // Location Master parent submenu
            $locationMaster = SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => null,
                'name' => 'Location Master',
                'route' => null,
                'priority' => 1,
                'status' => 1
            ]);

            // Location Master child submenus
            SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => $locationMaster->id,
                'name' => 'State',
                'route' => '/masters/location/state',
                'priority' => 1,
                'status' => 1
            ]);

            SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => $locationMaster->id,
                'name' => 'District',
                'route' => '/masters/location/district',
                'priority' => 2,
                'status' => 1
            ]);

            SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => $locationMaster->id,
                'name' => 'City',
                'route' => '/masters/location/city',
                'priority' => 3,
                'status' => 1
            ]);

            // Role & Permission Master parent submenu
            $roleMaster = SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => null,
                'name' => 'Role & Permission Master',
                'route' => null,
                'priority' => 2,
                'status' => 1
            ]);

            // Role & Permission Master child submenus
            SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => $roleMaster->id,
                'name' => 'Roles/Designation',
                'route' => '/masters/user-role/designation',
                'priority' => 1,
                'status' => 1
            ]);

            SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => $roleMaster->id,
                'name' => 'Manage Menu',
                'route' => '/masters/menu/menu',
                'priority' => 2,
                'status' => 1
            ]);

            SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => $roleMaster->id,
                'name' => 'Manage Submenus',
                'route' => '/masters/menu/submenu',
                'priority' => 3,
                'status' => 1
            ]);

            SubMenu::create([
                'menu_id' => $mastersMenu->id,
                'parent_id' => $roleMaster->id,
                'name' => 'Permissions',
                'route' => '/masters/user-role/permissions',
                'priority' => 4,
                'status' => 1
            ]);
        }

        // Get Team Management menu
        $teamMenu = Menu::where('name', 'Team Management')->first();
        
        if ($teamMenu) {
            SubMenu::create([
                'menu_id' => $teamMenu->id,
                'parent_id' => null,
                'name' => 'Add Employee',
                'route' => '/team/add-employee',
                'priority' => 1,
                'status' => 1
            ]);

            SubMenu::create([
                'menu_id' => $teamMenu->id,
                'parent_id' => null,
                'name' => 'Employee List',
                'route' => '/team/employee-list',
                'priority' => 2,
                'status' => 1
            ]);
        }

        // Get Project Management menu
        $projectMenu = Menu::where('name', 'Project Management')->first();
        
        if ($projectMenu) {
            SubMenu::create([
                'menu_id' => $projectMenu->id,
                'parent_id' => null,
                'name' => 'Add New Project',
                'route' => '/project/add-project',
                'priority' => 1,
                'status' => 1
            ]);

            SubMenu::create([
                'menu_id' => $projectMenu->id,
                'parent_id' => null,
                'name' => 'Project List',
                'route' => '/project/project-list',
                'priority' => 2,
                'status' => 1
            ]);
        }
    }
}