let referenceCount = 1;
let coApplicantCount = 1;

document.addEventListener('DOMContentLoaded', function () {
    // Set co-applicant count from old values
    if (window.oldCoApplicantCount) {
        coApplicantCount = window.oldCoApplicantCount;
    }

    // Restore old form state
    if (window.oldCoApplicantVisible) {
        document.getElementById('co_applicant_section').style.display = 'block';
        const toggleBtn = document.getElementById('toggleCoApplicant');
        toggleBtn.textContent = 'Remove Co-Applicant';
        toggleBtn.classList.remove('btn-primary');
        toggleBtn.classList.add('btn-danger');
        document.getElementById('addMoreCoApplicant').style.display = 'inline-block';
    }

    if (window.oldGuarantorVisible) {
        document.getElementById('guarantor_section').style.display = 'block';
        const toggleBtn = document.getElementById('toggleGuarantor');
        toggleBtn.textContent = 'Remove Guarantor';
        toggleBtn.classList.remove('btn-primary');
        toggleBtn.classList.add('btn-danger');
    }

    // Restore old references
    if (window.oldReferences > 1) {
        for (let i = 2; i <= window.oldReferences; i++) {
            const container = document.getElementById('referencesContainer');
            const newRow = document.createElement('div');
            newRow.className = 'row reference-row';
            newRow.innerHTML = `
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="reference_${i}" class="form-label">Reference Name</label>
                        <input type="text" class="form-control" id="reference_${i}" name="reference_${i}">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="reference_${i}_contact_no" class="form-label">Reference Contact No</label>
                        <input type="text" class="form-control" id="reference_${i}_contact_no" name="reference_${i}_contact_no">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="reference_${i}_relation_id" class="form-label">Reference Relation</label>
                        <select class="form-control" id="reference_${i}_relation_id" name="reference_${i}_relation_id">
                            <option value="">Select Relation</option>
                            ${window.relationOptions}
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-danger btn-sm d-block removeReference">Remove</button>
                    </div>
                </div>
            `;
            container.appendChild(newRow);
        }
        referenceCount = window.oldReferences;
        document.querySelectorAll('.removeReference').forEach(btn => {
            btn.style.display = 'block';
        });
    }

    // Handle state change to load cities
    document.getElementById('current_state').addEventListener('change', function () {
        const stateId = this.value;
        const citySelect = document.getElementById('current_city');

        // Clear city dropdown
        citySelect.innerHTML = '<option value="">Select City</option>';

        if (stateId) {
            // Show loading state
            citySelect.innerHTML = '<option value="">Loading cities...</option>';

            // Fetch cities for selected state
            fetch(`/api/cities-by-state/${stateId}`)
                .then(response => response.json())
                .then(cities => {
                    citySelect.innerHTML = '<option value="">Select City</option>';
                    cities.forEach(city => {
                        citySelect.innerHTML += `<option value="${city.id}">${city.name}</option>`;
                    });
                })
                .catch(error => {
                    citySelect.innerHTML = '<option value="">Error loading cities</option>';
                });
        }
    });

    // Age calculation for main applicant DOB
    document.getElementById('dob').addEventListener('change', function() {
        const dob = new Date(this.value);
        const today = new Date();
        let age = today.getFullYear() - dob.getFullYear();
        const monthDiff = today.getMonth() - dob.getMonth();
        if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < dob.getDate())) {
            age--;
        }
        document.getElementById('age').value = age >= 0 ? age : '';
    });

    // Age calculation for co-applicant DOB
    document.getElementById('co_applicant_dob').addEventListener('change', function() {
        const dob = new Date(this.value);
        const today = new Date();
        let age = today.getFullYear() - dob.getFullYear();
        const monthDiff = today.getMonth() - dob.getMonth();
        if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < dob.getDate())) {
            age--;
        }
        document.getElementById('co_applicant_age').value = age >= 0 ? age : '';
    });

    // Handle co-applicant state change to load cities
    document.addEventListener('change', function(e) {
        if (e.target.classList.contains('co-applicant-state-select')) {
            const stateId = e.target.value;
            const targetCityId = e.target.getAttribute('data-target');
            const citySelect = document.getElementById(targetCityId);

            // Clear city dropdown
            citySelect.innerHTML = '<option value="">Select City</option>';

            if (stateId) {
                // Show loading state
                citySelect.innerHTML = '<option value="">Loading cities...</option>';

                // Fetch cities for selected state
                fetch(`/api/cities-by-state/${stateId}`)
                    .then(response => response.json())
                    .then(cities => {
                        citySelect.innerHTML = '<option value="">Select City</option>';
                        cities.forEach(city => {
                            citySelect.innerHTML += `<option value="${city.id}">${city.name}</option>`;
                        });
                    })
                    .catch(error => {
                        citySelect.innerHTML = '<option value="">Error loading cities</option>';
                    });
            }
        }
        
        // Handle guarantor state change to load cities
        if (e.target.classList.contains('guarantor-state-select')) {
            const stateId = e.target.value;
            const targetCityId = e.target.getAttribute('data-target');
            const citySelect = document.getElementById(targetCityId);

            // Clear city dropdown
            citySelect.innerHTML = '<option value="">Select City</option>';

            if (stateId) {
                // Show loading state
                citySelect.innerHTML = '<option value="">Loading cities...</option>';

                // Fetch cities for selected state
                fetch(`/api/cities-by-state/${stateId}`)
                    .then(response => response.json())
                    .then(cities => {
                        citySelect.innerHTML = '<option value="">Select City</option>';
                        cities.forEach(city => {
                            citySelect.innerHTML += `<option value="${city.id}">${city.name}</option>`;
                        });
                    })
                    .catch(error => {
                        citySelect.innerHTML = '<option value="">Error loading cities</option>';
                    });
            }
        }
    });

    // Branch change handler
    document.getElementById('branch_id').addEventListener('change', function () {
        const branchId = this.value;
        const bmSelect = document.getElementById('bm_name_id');
        const assignToSelect = document.getElementById('assign_to');

        // Clear existing options
        bmSelect.innerHTML = '<option value="">Select BM</option>';
        assignToSelect.innerHTML = '<option value="">Select User</option>';

        if (branchId) {
            // Find users for selected branch
            const allUsers = window.usersData || [];

            // Filter users by branch_id
            const branchUsers = allUsers.filter(user => user.branch_id == branchId);

            if (branchUsers.length > 0) {
                // Show users from selected branch
                branchUsers.forEach(user => {
                    const fullName = (user.name || '').trim() || 'Unknown';
                    bmSelect.innerHTML += `<option value="${user.id}">${fullName}</option>`;
                });
            } else {
                // Show all users if no users assigned to this branch
                allUsers.forEach(user => {
                    const fullName = (user.name || '').trim() || 'Unknown';
                    bmSelect.innerHTML += `<option value="${user.id}">${fullName}</option>`;
                });
            }

            // Load RO users for assign_to dropdown
            fetch(`/api/branch-staff/${branchId}`)
                .then(response => response.json())
                .then(roUsers => {
                    roUsers.forEach(user => {
                        assignToSelect.innerHTML += `<option value="${user.id}">${user.name}</option>`;
                    });
                })
                .catch(error => {
                    console.error('Error loading RO users:', error);
                });
        }
    });

    // Add reference handler
    document.getElementById('addReference').addEventListener('click', function () {
        referenceCount++;
        const container = document.getElementById('referencesContainer');
        const newRow = document.createElement('div');
        newRow.className = 'row reference-row';
        newRow.innerHTML = `
            <div class="col-md-3">
                <div class="mb-3">
                    <label for="reference_${referenceCount}" class="form-label">Reference Name</label>
                    <input type="text" class="form-control" id="reference_${referenceCount}" name="reference_${referenceCount}">
                </div>
            </div>
            <div class="col-md-3">
                <div class="mb-3">
                    <label for="reference_${referenceCount}_contact_no" class="form-label">Reference Contact No</label>
                    <input type="text" class="form-control" id="reference_${referenceCount}_contact_no" name="reference_${referenceCount}_contact_no">
                </div>
            </div>
            <div class="col-md-3">
                <div class="mb-3">
                    <label for="reference_${referenceCount}_relation_id" class="form-label">Reference Relation</label>
                    <select class="form-control" id="reference_${referenceCount}_relation_id" name="reference_${referenceCount}_relation_id">
                        <option value="">Select Relation</option>
                        ${window.relationOptions || ''}
                    </select>
                </div>
            </div>
            <div class="col-md-3">
                <div class="mb-3">
                    <label class="form-label">&nbsp;</label>
                    <button type="button" class="btn btn-danger btn-sm d-block removeReference">Remove</button>
                </div>
            </div>
        `;
        container.appendChild(newRow);

        // Show remove buttons for all rows except first
        document.querySelectorAll('.removeReference').forEach(btn => {
            btn.style.display = 'block';
        });
    });

    // Remove reference handler
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('removeReference')) {
            e.target.closest('.reference-row').remove();

            // Hide remove button if only one row left
            const rows = document.querySelectorAll('.reference-row');
            if (rows.length === 1) {
                rows[0].querySelector('.removeReference').style.display = 'none';
            }
        }
    });

    // Toggle Co-Applicant Section
    document.getElementById('toggleCoApplicant').addEventListener('click', function () {
        const section = document.getElementById('co_applicant_section');
        const button = this;
        const addMoreBtn = document.getElementById('addMoreCoApplicant');

        if (section.style.display === 'none') {
            section.style.display = 'block';
            button.textContent = 'Remove Co-Applicant';
            button.classList.remove('btn-primary');
            button.classList.add('btn-danger');
            addMoreBtn.style.display = 'inline-block';
        } else {
            section.style.display = 'none';
            button.textContent = 'Add Co-Applicant';
            button.classList.remove('btn-danger');
            button.classList.add('btn-primary');
            addMoreBtn.style.display = 'none';
        }
    });

    // Toggle Guarantor Section
    document.getElementById('toggleGuarantor').addEventListener('click', function () {
        const section = document.getElementById('guarantor_section');
        const button = this;

        if (section.style.display === 'none') {
            section.style.display = 'block';
            button.textContent = 'Remove Guarantor';
            button.classList.remove('btn-primary');
            button.classList.add('btn-danger');
        } else {
            section.style.display = 'none';
            button.textContent = 'Add Guarantor';
            button.classList.remove('btn-danger');
            button.classList.add('btn-primary');
        }
    });

    // Add More Co-Applicants
    document.getElementById('addMoreCoApplicant').addEventListener('click', function () {
        coApplicantCount++;
        const container = document.getElementById('additionalCoApplicants');
        const newCoApplicant = document.createElement('div');
        newCoApplicant.className = 'additional-co-applicant';
        newCoApplicant.innerHTML = `
            <hr class="my-4">
            <h4 class="mt-4">Co-Applicant ${coApplicantCount} <button type="button" class="btn btn-danger btn-sm ms-2 removeCoApplicant">Remove</button></h4>
            <h5 class="mt-3">Basic Information</h5>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">First Name</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_first_name"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Middle Name</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_middle_name"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Last Name</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_last_name"></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Father Name</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_father_name"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Caste</label><select class="form-control" name="co_applicant_${coApplicantCount}_caste"><option value="">Select Caste</option>${window.casteOptions || ''}</select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">DOB</label><input type="date" class="form-control" name="co_applicant_${coApplicantCount}_dob"></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Age</label><input type="number" class="form-control" name="co_applicant_${coApplicantCount}_age"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Gender</label><select class="form-control" name="co_applicant_${coApplicantCount}_gender"><option value="">Select Gender</option>${window.genderOptions || ''}</select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Co Applicant Image</label><input type="file" class="form-control" name="co_applicant_${coApplicantCount}_image" accept="image/*"></div></div>
            </div>
            <h5 class="mt-4">Contact Information</h5>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Contact Number</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_contact_number"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Contact Verified</label><select class="form-control" name="co_applicant_${coApplicantCount}_contact_verified"><option value="0">No</option><option value="1">Yes</option></select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Email</label><input type="email" class="form-control" name="co_applicant_${coApplicantCount}_email"></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Address Type</label><select class="form-control" name="co_applicant_${coApplicantCount}_address_type"><option value="">Select Type</option>${window.addressTypeOptions || ''}</select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Pincode</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_current_pincode"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Current State</label><select class="form-control co-applicant-state-select" name="co_applicant_${coApplicantCount}_current_state" data-target="co_applicant_${coApplicantCount}_current_city"><option value="">Select State</option>${window.stateOptions || ''}</select></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Current City</label><select class="form-control co-applicant-city-select" name="co_applicant_${coApplicantCount}_current_city" id="co_applicant_${coApplicantCount}_current_city"><option value="">Select City</option></select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Current Address</label><textarea class="form-control" name="co_applicant_${coApplicantCount}_current_address" rows="1"></textarea></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Place of Birth</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_place_of_birth"></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Nationality</label><select class="form-control" name="co_applicant_${coApplicantCount}_nationality"><option value="">Select Nationality</option>${window.nationalityOptions || ''}</select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Marital Status</label><select class="form-control" name="co_applicant_${coApplicantCount}_marital_status"><option value="">Select Status</option>${window.maritalStatusOptions || ''}</select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Spouse Name</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_spouse_name"></div></div>
            </div>
            <h5 class="mt-4">Identity Documents</h5>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">PAN</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_pan"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">PAN Verified</label><select class="form-control" name="co_applicant_${coApplicantCount}_pan_verified"><option value="0">No</option><option value="1">Yes</option></select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Aadhaar</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_aadhaar"></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Aadhaar Verified</label><select class="form-control" name="co_applicant_${coApplicantCount}_aadhaar_verified"><option value="0">No</option><option value="1">Yes</option></select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Form 60</label><select class="form-control" name="co_applicant_${coApplicantCount}_form_60"><option value="0">No</option><option value="1">Yes</option></select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Voter ID</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_voter_id"></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Voter ID Verified</label><select class="form-control" name="co_applicant_${coApplicantCount}_voter_id_verified"><option value="0">No</option><option value="1">Yes</option></select></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Driving License</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_driving_license"></div></div>
                <div class="col-md-4"><div class="mb-3"><label class="form-label">DL Verified</label><select class="form-control" name="co_applicant_${coApplicantCount}_driving_license_verified"><option value="0">No</option><option value="1">Yes</option></select></div></div>
            </div>
            <div class="row">
                <div class="col-md-4"><div class="mb-3"><label class="form-label">Passport</label><input type="text" class="form-control" name="co_applicant_${coApplicantCount}_passport"></div></div>
            </div>
        `;
        container.appendChild(newCoApplicant);
    });

    // Remove Co-Applicant
    document.addEventListener('click', function (e) {
        if (e.target.classList.contains('removeCoApplicant')) {
            e.target.closest('.additional-co-applicant').remove();
        }
    });

    // Form validation based on section visibility
    document.getElementById('leadForm').addEventListener('submit', function (e) {
        const coApplicantSection = document.getElementById('co_applicant_section');
        const guarantorSection = document.getElementById('guarantor_section');

        // Disable required validation for hidden co-applicant section
        if (coApplicantSection.style.display === 'none') {
            coApplicantSection.querySelectorAll('[required]').forEach(field => {
                field.removeAttribute('required');
            });
        }

        // Disable required validation for hidden guarantor section
        if (guarantorSection.style.display === 'none') {
            guarantorSection.querySelectorAll('[required]').forEach(field => {
                field.removeAttribute('required');
            });
        }
    });

    // GPS Location functionality
    document.getElementById('gpsSync').addEventListener('click', function () {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                const lat = position.coords.latitude;
                const lng = position.coords.longitude;
                document.getElementById('gps_tagging').value = lat + ',' + lng;
            }, function (error) {
                alert('Error getting location: ' + error.message);
            });
        } else {
            alert('Geolocation is not supported by this browser.');
        }
    });
});