@extends('layout.layout')
@section('content')
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}
.modern-table {
    background: white;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    border: none;
}
.modern-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}
.modern-table thead th {
    color: white;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    padding: 20px 16px;
    border: none;
}
.modern-table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #f1f5f9;
}
.modern-table tbody tr:hover {
    background: #f8fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.modern-table tbody td {
    padding: 16px;
    vertical-align: middle;
    border: none;
    font-size: 14px;
    color: #475569;
}
.sr-number {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    color: #475569;
    font-size: 13px;
}
.header-section {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    border-radius: 16px;
    padding: 24px;
    margin-bottom: 24px;
    border: 1px solid #e2e8f0;
}
.page-title {
    font-size: 28px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}
.page-subtitle {
    color: #64748b;
    font-size: 16px;
    margin: 4px 0 0 0;
}
.add-btn {
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: white;
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}
.add-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(59, 130, 246, 0.4);
    color: white;
}
</style>
<div class="page-content">
    <div class="container-fluid">
        <div class="header-section">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="page-title">Customers</h1>
                    <p class="page-subtitle">Manage your customer database</p>
                </div>
                <a href="{{ route('customer.create') }}" class="add-btn">
                    <i class="fas fa-plus me-2"></i>Add New Customer
                </a>
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show border-0 shadow-sm mb-4" style="border-radius: 12px;">
                <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="modern-table">
            <table class="table mb-0" role="grid">
                <thead>
                    <tr>
                        <th style="width: 80px;">S.No.</th>
                        <th>Customer Name</th>
                        <th>Firm Name</th>
                        <th>Contact Number</th>
                        <th>Email</th>
                        <th>GST Number</th>
                        <th>Created Date</th>
                        <th style="width: 200px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($customers as $index => $customer)
                    <tr>
                        <td>
                            <div class="sr-number">{{ $customers->firstItem() + $index }}</div>
                        </td>                                        
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <h5 class="fs-14 mb-1">
                                        <a href="#" class="text-body">{{ $customer->customer_name }}</a>
                                    </h5>
                                    <p class="text-muted mb-0">ID: <span class="fw-medium">#{{ $customer->id }}</span></p>
                                </div>
                            </div>
                        </td>
                        <td>{{ $customer->firm_name ?? 'N/A' }}</td>
                        <td>{{ $customer->contact_number }}</td>
                        <td>{{ $customer->email }}</td>
                        <td>{{ $customer->gst_number ?? 'N/A' }}</td>
                        <td>{{ $customer->created_at->format('d-m-Y') }}</td>
                        <td>
                            <a href="{{ route('customer.edit', $customer) }}" class="btn btn-sm btn-warning" title="Edit"><i class="ri-pencil-line"></i></a>
                            <form method="POST" action="{{ route('customer.destroy', $customer) }}" style="display: inline;" onsubmit="return confirm('Are you sure you want to delete this customer?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger" title="Delete"><i class="ri-delete-bin-line"></i></button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">No customers found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection