@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Create New Lead</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Lead Management</a></li>
                                <li class="breadcrumb-item active">Create New Lead</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Lead Information</h4>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('lead.store') }}" method="POST" id="leadForm" enctype="multipart/form-data">
                                @csrf

                                <!-- Basic Information -->
                                <h1 class="mt-1">Applicant Details</h1>
                                <section id="applicant_section"
                                    style="border-bottom: 2px dashed #7c7f90; padding-bottom: 50px;">
                                    <h4 class="mt-3">Basic Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="segment" class="form-label">Segment</label>
                                                <select class="form-select" id="segment" name="segment">
                                                    <option value="">Select Segment</option>
                                                    @if (isset($dropdownFields['segment']))
                                                        @foreach ($dropdownFields['segment']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('segment') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="loan_type" class="form-label">Loan Type</label>
                                                <select class="form-select" id="loan_type" name="loan_type">
                                                    <option value="">Select Loan Type</option>
                                                    @if (isset($dropdownFields['loan_type']))
                                                        @foreach ($dropdownFields['loan_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('loan_type') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="customer_type" class="form-label">Customer Type</label>
                                                <select class="form-select" id="customer_type" name="customer_type">
                                                    <option value="">Select Type</option>
                                                    @if (isset($dropdownFields['customer_type']))
                                                        @foreach ($dropdownFields['customer_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('customer_type') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_first_name" class="form-label">First Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="applicant_first_name"
                                                    name="applicant_first_name" value="{{ old('applicant_first_name') }}">
                                                @error('applicant_first_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_middle_name" class="form-label">Middle Name</label>
                                                <input type="text" class="form-control" id="applicant_middle_name"
                                                    name="applicant_middle_name"
                                                    value="{{ old('applicant_middle_name') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_last_name" class="form-label">Last Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="applicant_last_name"
                                                    name="applicant_last_name" value="{{ old('applicant_last_name') }}">
                                                @error('applicant_last_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="father_name" class="form-label">Father Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="father_name"
                                                    name="father_name" value="{{ old('father_name') }}">
                                                @error('father_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="caste" class="form-label">Caste</label>
                                                <select class="form-select" id="caste" name="caste">
                                                    <option value="">Select Caste</option>
                                                    @if (isset($dropdownFields['caste']))
                                                        @foreach ($dropdownFields['caste']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('caste') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="dob" class="form-label">DOB</label>
                                                <input type="date" class="form-control" id="dob" name="dob"
                                                    value="{{ old('dob') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="age" class="form-label">Age</label>
                                                <input type="number" class="form-control" id="age" name="age"
                                                    value="{{ old('age') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="gender" class="form-label">Gender</label>
                                                <select class="form-select" id="gender" name="gender">
                                                    <option value="">Select Gender</option>
                                                    @if (isset($dropdownFields['gender']))
                                                        @foreach ($dropdownFields['gender']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('gender') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                          <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="applicant_image" class="form-label">Applicant Image</label>
                                                <input type="file" class="form-control" id="applicant_image" name="applicant_image">
                                            </div>
                                        </div>

                                    </div>

                                    <!-- Contact Information -->
                                    <h4 class="mt-4">Contact Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="contact_number" class="form-label">Contact Number <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="contact_number"
                                                    name="contact_number" value="{{ old('contact_number') }}">
                                                @error('contact_number')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="contact_verified" class="form-label">Contact Verified</label>
                                                <select class="form-select" id="contact_verified"
                                                    name="contact_verified">
                                                    <option value="0"
                                                        {{ old('contact_verified') == '0' ? 'selected' : '' }}>No</option>
                                                    <option value="1"
                                                        {{ old('contact_verified') == '1' ? 'selected' : '' }}>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email</label>
                                                <input type="email" class="form-control" id="email" name="email"
                                                    value="{{ old('email') }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="address_type" class="form-label">Address Type</label>
                                                <select class="form-select" id="address_type" name="address_type">
                                                    <option value="">Select Type</option>
                                                    @if (isset($dropdownFields['address_type']))
                                                        @foreach ($dropdownFields['address_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('address_type') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_pincode" class="form-label">Pincode <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="current_pincode"
                                                    name="current_pincode" value="{{ old('current_pincode') }}">
                                                @error('current_pincode')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_state" class="form-label">Current State</label>
                                                <select class="form-select" id="current_state" name="current_state">
                                                    <option value="">Select State</option>
                                                    @foreach ($states as $state)
                                                        <option value="{{ $state->id }}"
                                                            {{ old('current_state') == $state->id ? 'selected' : '' }}>
                                                            {{ $state->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_city" class="form-label">Current City</label>
                                                <select class="form-select" id="current_city" name="current_city">
                                                    <option value="">Select City</option>
                                                    @if (old('current_city'))
                                                        @foreach ($cities->where('state_id', old('current_state')) as $city)
                                                            <option value="{{ $city->id }}"
                                                                {{ old('current_city') == $city->id ? 'selected' : '' }}>
                                                                {{ $city->name }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="current_address" class="form-label">Current Address <span
                                                        class="text-danger"></span></label>
                                                <textarea class="form-control" id="current_address" name="current_address" rows="1">{{ old('current_address') }}</textarea>
                                                @error('current_address')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="place_of_birth" class="form-label">Place of Birth <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="place_of_birth"
                                                    name="place_of_birth" value="{{ old('place_of_birth') }}">
                                                @error('place_of_birth')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>


                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="nationality" class="form-label">Nationality</label>
                                                <select class="form-select" id="nationality" name="nationality">
                                                    <option value="">Select Nationality</option>
                                                    @if (isset($dropdownFields['nationality']))
                                                        @foreach ($dropdownFields['nationality']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('nationality') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>

                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="marital_status" class="form-label">Marital Status</label>
                                                <select class="form-select" id="marital_status" name="marital_status">
                                                    <option value="">Select Status</option>
                                                    @if (isset($dropdownFields['marital_status']))
                                                        @foreach ($dropdownFields['marital_status']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('marital_status') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="spouse_name" class="form-label">Spouse Name</label>
                                                <input type="text" class="form-control" id="spouse_name"
                                                    name="spouse_name" value="{{ old('spouse_name') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Identity Documents -->
                                    <h4 class="mt-4">Identity Documents</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="pan" class="form-label">PAN</label>
                                                <input type="text" class="form-control" id="pan" name="pan"
                                                    value="{{ old('pan') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="pan_verified" class="form-label">PAN Verified</label>
                                                <select class="form-select" id="pan_verified" name="pan_verified">
                                                    <option value="0"
                                                        {{ old('pan_verified') == '0' ? 'selected' : '' }}>No</option>
                                                    <option value="1"
                                                        {{ old('pan_verified') == '1' ? 'selected' : '' }}>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="aadhaar" class="form-label">Aadhaar</label>
                                                <input type="text" class="form-control" id="aadhaar" name="aadhaar"
                                                    value="{{ old('aadhaar') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="aadhaar_verified" class="form-label">Aadhaar Verified</label>
                                                <select class="form-select" id="aadhaar_verified"
                                                    name="aadhaar_verified">
                                                    <option value="0"
                                                        {{ old('aadhaar_verified') == '0' ? 'selected' : '' }}>No</option>
                                                    <option value="1"
                                                        {{ old('aadhaar_verified') == '1' ? 'selected' : '' }}>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="form_60" class="form-label">Form 60</label>
                                                <select class="form-select" id="form_60" name="form_60">
                                                    <option value="0" {{ old('form_60') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1" {{ old('form_60') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="voter_id" class="form-label">Voter ID</label>
                                                <input type="text" class="form-control" id="voter_id"
                                                    name="voter_id" value="{{ old('voter_id') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="voter_id_verified" class="form-label">Voter ID
                                                    Verified</label>
                                                <select class="form-select" id="voter_id_verified"
                                                    name="voter_id_verified">
                                                    <option value="0"
                                                        {{ old('voter_id_verified') == '0' ? 'selected' : '' }}>No</option>
                                                    <option value="1"
                                                        {{ old('voter_id_verified') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="driving_license" class="form-label">Driving License</label>
                                                <input type="text" class="form-control" id="driving_license"
                                                    name="driving_license" value="{{ old('driving_license') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="driving_license_verified" class="form-label">DL
                                                    Verified</label>
                                                <select class="form-select" id="driving_license_verified"
                                                    name="driving_license_verified">
                                                    <option value="0"
                                                        {{ old('driving_license_verified') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('driving_license_verified') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="passport" class="form-label">Passport</label>
                                                <input type="text" class="form-control" id="passport"
                                                    name="passport" value="{{ old('passport') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Banking and References -->
                                    <h4 class="mt-4">Banking & References</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="banking_info_id" class="form-label">Banking Info</label>
                                                <select class="form-select" id="banking_info" name="banking_info">
                                                    <option value="">Select Status</option>
                                                    @if (isset($dropdownFields['banking_info']))
                                                        @foreach ($dropdownFields['banking_info']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('banking_info') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="mb-3">
                                                <label class="form-label">References</label>
                                                <button type="button" class="btn btn-sm btn-primary float-end"
                                                    id="addReference">Add More</button>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="referencesContainer">
                                        @php
                                            $referenceCount = 0;
                                            foreach (old() as $key => $value) {
                                                if (
                                                    str_starts_with($key, 'reference_') &&
                                                    !str_contains($key, '_relation_id') &&
                                                    !str_contains($key, '_contact_no') &&
                                                    !empty($value)
                                                ) {
                                                    $referenceCount++;
                                                }
                                            }
                                            $referenceCount = max(1, $referenceCount);
                                        @endphp

                                        @for ($i = 1; $i <= $referenceCount; $i++)
                                            <div class="row reference-row">
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="reference_{{ $i }}"
                                                            class="form-label">Reference Name</label>
                                                        <input type="text" class="form-control"
                                                            id="reference_{{ $i }}"
                                                            name="reference_{{ $i }}"
                                                            value="{{ old('reference_' . $i) }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="reference_{{ $i }}_contact_no"
                                                            class="form-label">Reference Contact No</label>
                                                        <input type="text" class="form-control"
                                                            id="reference_{{ $i }}_contact_no"
                                                            name="reference_{{ $i }}_contact_no"
                                                            value="{{ old('reference_' . $i . '_contact_no') }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label for="reference_{{ $i }}_relation_id"
                                                            class="form-label">Reference
                                                            Relation</label>
                                                        <select class="form-select"
                                                            id="reference_{{ $i }}_relation_id"
                                                            name="reference_{{ $i }}_relation_id">
                                                            <option value="">Select Relation</option>
                                                            @if (isset($dropdownFields['relation_with_applicant']))
                                                                @foreach ($dropdownFields['relation_with_applicant']->options as $option)
                                                                    <option value="{{ $option->id }}"
                                                                        {{ old('reference_' . $i . '_relation_id') == $option->id ? 'selected' : '' }}>
                                                                        {{ $option->option_value }}
                                                                    </option>
                                                                @endforeach
                                                            @endif
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="mb-3">
                                                        <label class="form-label">&nbsp;</label>
                                                        <button type="button"
                                                            class="btn btn-danger btn-sm d-block removeReference"
                                                            style="{{ $i == 1 ? 'display:none;' : '' }}">Remove</button>
                                                    </div>
                                                </div>
                                            </div>
                                        @endfor
                                    </div>

                                    <!-- Loan Information -->
                                    <h4 class="mt-4">Loan Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="login_date" class="form-label">Login Date</label>
                                                <input type="date" class="form-control" id="login_date"
                                                    name="login_date" value="{{ old('login_date') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="login_amount" class="form-label">Login Amount</label>
                                                <input type="number" step="0.01" class="form-control"
                                                    id="login_amount" name="login_amount"
                                                    value="{{ old('login_amount') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="tenure_id" class="form-label">Tenure</label>
                                                <select class="form-select" id="tenure" name="tenure">
                                                    <option value="">Select Tenure</option>
                                                    @if (isset($dropdownFields['tenure']))
                                                        @foreach ($dropdownFields['tenure']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('tenure') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="roi" class="form-label">ROI</label>
                                                <input type="number" step="0.01" class="form-control" id="roi"
                                                    name="roi" value="{{ old('roi') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="branch_id" class="form-label">Branch</label>
                                                <select class="form-select" id="branch_id" name="branch_id">
                                                    <option value="">Select Branch</option>
                                                    @foreach ($branches as $branch)
                                                        @if (Auth::user()->role_id != 1)
                                                            @if (Auth::user()->branch_id == $branch->id)
                                                                <option value="{{ $branch->id }}">
                                                                    {{ $branch->branch_name }}
                                                                </option>
                                                            @endif
                                                        @else
                                                            <option value="{{ $branch->id }}"
                                                                {{ old('branch_id') == $branch->id ? 'selected' : '' }}>
                                                                {{ $branch->branch_name }}
                                                            </option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="bm_name_id" class="form-label">BM Name</label>
                                                <select class="form-select" id="bm_name_id" name="bm_name_id">
                                                    <option value="">Select BM</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="rm_name" class="form-label">RM Name</label>
                                                <input type="text" class="form-control" id="rm_name" name="rm_name"
                                                    value="{{ old('rm_name') }}">
                                            </div>
                                        </div>


                                    </div>


                                    <!-- BT/IMD Information -->
                                    <h4 class="mt-4">BT/IMD Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="bt_yes_no_id" class="form-label">BT (Yes/No)</label>
                                                <select class="form-select" id="bt_yes_no_id" name="bt_yes_no_id">
                                                    <option value="">Select Option</option>
                                                    <option value="0"
                                                        {{ old('bt_yes_no_id') == '0' ? 'selected' : '' }}>No</option>
                                                    <option value="1"
                                                        {{ old('bt_yes_no_id') == '1' ? 'selected' : '' }}>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="bt_company_name" class="form-label">BT Company Name</label>
                                                <input type="text" class="form-control" id="bt_company_name"
                                                    name="bt_company_name" value="{{ old('bt_company_name') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="imd_waiver" class="form-label">IMD Waiver</label>
                                                <select class="form-select" id="imd_waiver" name="imd_waiver">
                                                    <option value="">Select Option</option>
                                                    @if (isset($dropdownFields['imd_waiver']))
                                                        @foreach ($dropdownFields['imd_waiver']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('imd_waiver') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="imd_transaction_ref" class="form-label">IMD Transaction
                                                    Ref</label>
                                                <input type="text" class="form-control" id="imd_transaction_ref"
                                                    name="imd_transaction_ref" value="{{ old('imd_transaction_ref') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Business Information -->
                                    <h4 class="mt-4">Business Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="business_address" class="form-label">Business Address</label>
                                                <textarea class="form-control" id="business_address" name="business_address" rows="1">{{ old('business_address') }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="annual_income" class="form-label">Annual Income</label>
                                                <input type="number" step="0.01" class="form-control"
                                                    id="annual_income" name="annual_income"
                                                    value="{{ old('annual_income') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="obligation" class="form-label">Obligation</label>
                                                <input type="number" step="0.01" class="form-control"
                                                    id="obligation" name="obligation" value="{{ old('obligation') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="foir" class="form-label">FOIR</label>
                                                <input type="number" step="0.01" class="form-control" id="foir"
                                                    name="foir" value="{{ old('foir') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="ltv" class="form-label">LTV</label>
                                                <input type="number" step="0.01" class="form-control" id="ltv"
                                                    name="ltv" value="{{ old('ltv') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="gps_tagging" class="form-label">GPS Tagging <span
                                                        id="gpsSync"
                                                        style="font-size: 14px; cursor: pointer;">🔄</span></label>
                                                <input type="text" class="form-control" id="gps_tagging"
                                                    name="gps_tagging" value="{{ old('gps_tagging') }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="property_type" class="form-label">Property Type</label>
                                                <select class="form-select" id="property_type" name="property_type">
                                                    <option value="">Select Type</option>
                                                    @if (isset($dropdownFields['property_type']))
                                                        @foreach ($dropdownFields['property_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('property_type') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="property_owner_name" class="form-label">Property Owner
                                                    Name</label>
                                                <input type="text" class="form-control" id="property_owner_name"
                                                    name="property_owner_name" value="{{ old('property_owner_name') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="property_address" class="form-label">Property Address</label>
                                                <textarea class="form-control" id="property_address" name="property_address" rows="1">{{ old('property_address') }}</textarea>
                                            </div>
                                        </div>

                                    </div>


                                    <!-- PSL Information -->
                                    <h4 class="mt-4">PSL Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_yes_no_id" class="form-label">PSL (Yes/No)</label>
                                                <select class="form-select" id="psl_yes_no_id" name="psl_yes_no_id">
                                                    <option value="">Select Option</option>
                                                    <option value="0"
                                                        {{ old('psl_yes_no_id') == '0' ? 'selected' : '' }}>No</option>
                                                    <option value="1"
                                                        {{ old('psl_yes_no_id') == '1' ? 'selected' : '' }}>Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="manufacturing_service_agriculture"
                                                    class="form-label">Manufacturing/Service/Agriculture</label>
                                                <select class="form-select" id="manufacturing_service_agriculture"
                                                    name="manufacturing_service_agriculture">
                                                    <option value="">Select Status</option>
                                                    @if (isset($dropdownFields['manufacturing_service_agriculture']))
                                                        @foreach ($dropdownFields['manufacturing_service_agriculture']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('manufacturing_service_agriculture') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_sub_category" class="form-label">PSL Sub Category</label>
                                                <select class="form-select" id="psl_sub_category"
                                                    name="psl_sub_category">
                                                    <option value="">Select Category</option>
                                                    @if (isset($dropdownFields['psl_sub_category']))
                                                        @foreach ($dropdownFields['psl_sub_category']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('psl_sub_category') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="purpose_of_loans" class="form-label">Purpose of Loans</label>
                                                <select class="form-select" id="purpose_of_loans"
                                                    name="purpose_of_loans">
                                                    <option value="">Select Purpose</option>
                                                    @if (isset($dropdownFields['purpose_of_loans']))
                                                        @foreach ($dropdownFields['purpose_of_loans']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('purpose_of_loans') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_document_type" class="form-label">PSL Document
                                                    Type</label>
                                                <select class="form-select" id="psl_document_type"
                                                    name="psl_document_type">
                                                    <option value="">Select Type</option>
                                                    @if (isset($dropdownFields['psl_document_type']))
                                                        @foreach ($dropdownFields['psl_document_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('psl_document_type') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="psl_document_number" class="form-label">PSL Document
                                                    Number</label>
                                                <input type="text" class="form-control" id="psl_document_number"
                                                    name="psl_document_number" value="{{ old('psl_document_number') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="field_investigation_flag" class="form-label">Field
                                                    Investigation
                                                    Flag</label>
                                                <select class="form-select" id="field_investigation_flag"
                                                    name="field_investigation_flag">
                                                    <option value="0"
                                                        {{ old('field_investigation_flag') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('field_investigation_flag') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="tele_verification_flag" class="form-label">Tele Verification
                                                    Flag</label>
                                                <select class="form-select" id="tele_verification_flag"
                                                    name="tele_verification_flag">
                                                    <option value="0"
                                                        {{ old('tele_verification_flag') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('tele_verification_flag') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="personal_discussion_flag" class="form-label">Personal
                                                    Discussion
                                                    Flag</label>
                                                <select class="form-select" id="personal_discussion_flag"
                                                    name="personal_discussion_flag">
                                                    <option value="0"
                                                        {{ old('personal_discussion_flag') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('personal_discussion_flag') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>



                                    <!-- System Fields -->
                                    <h4 class="mt-4">Defaults</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="status" class="form-label">Lead Status</label>
                                                <select class="form-select" id="" name="status">
                                                    <option value="1" {{ old('status') == '1' ? 'selected' : '' }}>
                                                        New</option>
                                                    <option value="2" {{ old('status') == '2' ? 'selected' : '' }}>
                                                        RO Assigned</option>
                                                    <option value="3" {{ old('status') == '3' ? 'selected' : '' }}>
                                                        RO Verified</option>
                                                    <option value="4" {{ old('status') == '4' ? 'selected' : '' }}>
                                                        Branch Review</option>
                                                        <option value="5" {{ old('status') == '5' ? 'selected' : '' }}>
                                                        Branch Approved</option>
                                                    <option value="6" {{ old('status') == '6' ? 'selected' : '' }}>
                                                        Bank wise approve</option>
                                                    <option value="7" {{ old('status') == '7' ? 'selected' : '' }}>
                                                        Final Lead source</option>
                                                    <option value="90" {{ old('status') == '90' ? 'selected' : '' }}>
                                                        Cancelled</option>
                                                    <option value="91" {{ old('status') == '91' ? 'selected' : '' }}>
                                                        Other</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="assign_to" class="form-label">Lead Assign To</label>
                                                <select class="form-select" id="assign_to" name="assign_to">
                                                    <option value="">Select User</option>
                                                    {{-- @foreach ($ro_users as $ro_users_data)
                                                        <option value="{{ $ro_users_data->id }}"
                                                            {{ old('assign_to') == $ro_users_data->id ? 'selected' : '' }}>
                                                            {{ $ro_users_data->name }}
                                                        </option>
                                                    @endforeach --}}
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                </section>













                                <!--CO Applicant Basic Information -->
                                <h1 class="mt-5">CO Applicant Details <button type="button"
                                        class="btn btn-primary btn-sm ms-3" id="toggleCoApplicant">Add
                                        Co-Applicant</button> <button type="button" class="btn btn-success btn-sm ms-2"
                                        id="addMoreCoApplicant" style="display: none;">Add More</button></h1>
                                <section id="co_applicant_section"
                                    style="display: none; border-bottom: 2px dashed #7c7f90; padding-bottom: 50px;">
                                    <h4 class="mt-3">Basic Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_first_name" class="form-label">First Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="co_applicant_first_name"
                                                    name="co_applicant_first_name"
                                                    value="{{ old('co_applicant_first_name') }}">
                                                @error('co_applicant_first_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_middle_name" class="form-label">Middle
                                                    Name</label>
                                                <input type="text" class="form-control" id="co_applicant_middle_name"
                                                    name="co_applicant_middle_name"
                                                    value="{{ old('co_applicant_middle_name') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_last_name" class="form-label">Last Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="co_applicant_last_name"
                                                    name="co_applicant_last_name"
                                                    value="{{ old('co_applicant_last_name') }}">
                                                @error('co_applicant_last_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_father_name" class="form-label">Father Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="co_applicant_father_name"
                                                    name="co_applicant_father_name"
                                                    value="{{ old('co_applicant_father_name') }}">
                                                @error('co_applicant_father_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_caste" class="form-label">Caste</label>
                                                <select class="form-select" id="co_applicant_caste"
                                                    name="co_applicant_caste">
                                                    <option value="">Select Caste</option>
                                                    @if (isset($dropdownFields['caste']))
                                                        @foreach ($dropdownFields['caste']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('co_applicant_caste') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_dob" class="form-label">DOB</label>
                                                <input type="date" class="form-control" id="co_applicant_dob"
                                                    name="co_applicant_dob" value="{{ old('co_applicant_dob') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_age" class="form-label">Age</label>
                                                <input type="number" class="form-control" id="co_applicant_age"
                                                    name="co_applicant_age" value="{{ old('co_applicant_age') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_gender" class="form-label">Gender</label>
                                                <select class="form-select" id="co_applicant_gender"
                                                    name="co_applicant_gender">
                                                    <option value="">Select Gender</option>
                                                    @if (isset($dropdownFields['gender']))
                                                        @foreach ($dropdownFields['gender']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('co_applicant_gender') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

  <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_image" class="form-label">Co Applicant Image</label>
                                                <input type="file" class="form-control" id="co_applicant_image"
                                                    name="co_applicant_image"  accept="image/*">
                                            </div>
                                        </div>

                                    </div>

                                    <!-- Contact Information -->
                                    <h4 class="mt-4">Contact Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_contact_number" class="form-label">Contact Number
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_contact_number" name="co_applicant_contact_number"
                                                    value="{{ old('co_applicant_contact_number') }}">
                                                @error('co_applicant_contact_number')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_contact_verified" class="form-label">Contact
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_contact_verified"
                                                    name="co_applicant_contact_verified">
                                                    <option value="0"
                                                        {{ old('co_applicant_contact_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('co_applicant_contact_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_email" class="form-label">Email</label>
                                                <input type="email" class="form-control" id="co_applicant_email"
                                                    name="co_applicant_email" value="{{ old('co_applicant_email') }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_address_type" class="form-label">Address
                                                    Type</label>
                                                <select class="form-select" id="co_applicant_address_type"
                                                    name="co_applicant_address_type">
                                                    <option value="">Select Type</option>
                                                    @if (isset($dropdownFields['address_type']))
                                                        @foreach ($dropdownFields['address_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('co_applicant_address_type') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_pincode" class="form-label">Pincode <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_current_pincode" name="co_applicant_current_pincode"
                                                    value="{{ old('co_applicant_current_pincode') }}">
                                                @error('co_applicant_current_pincode')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_state" class="form-label">Current
                                                    State</label>
                                                <select class="form-control co-applicant-state-select"
                                                    id="co_applicant_current_state" name="co_applicant_current_state"
                                                    data-target="co_applicant_current_city">
                                                    <option value="">Select State</option>
                                                    @foreach ($states as $state)
                                                        <option value="{{ $state->id }}"
                                                            {{ old('co_applicant_current_state') == $state->id ? 'selected' : '' }}>
                                                            {{ $state->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_city" class="form-label">Current
                                                    City</label>
                                                <select class="form-control co-applicant-city-select"
                                                    id="co_applicant_current_city" name="co_applicant_current_city">
                                                    <option value="">Select City</option>
                                                    @if (old('co_applicant_current_state'))
                                                        @foreach ($cities->where('state_id', old('co_applicant_current_state')) as $city)
                                                            <option value="{{ $city->id }}"
                                                                {{ old('co_applicant_current_city') == $city->id ? 'selected' : '' }}>
                                                                {{ $city->name }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_current_address" class="form-label">Current
                                                    Address <span class="text-danger"></span></label>
                                                <textarea class="form-control" id="co_applicant_current_address" name="co_applicant_current_address" rows="1">{{ old('co_applicant_current_address') }}</textarea>
                                                @error('co_applicant_current_address')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_place_of_birth" class="form-label">Place of Birth
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_place_of_birth" name="co_applicant_place_of_birth"
                                                    value="{{ old('co_applicant_place_of_birth') }}">
                                                @error('co_applicant_place_of_birth')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_nationality"
                                                    class="form-label">Nationality</label>
                                                <select class="form-select" id="co_applicant_nationality"
                                                    name="co_applicant_nationality">
                                                    <option value="">Select Nationality</option>
                                                    @if (isset($dropdownFields['nationality']))
                                                        @foreach ($dropdownFields['nationality']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('co_applicant_nationality') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_marital_status" class="form-label">Marital
                                                    Status</label>
                                                <select class="form-select" id="co_applicant_marital_status"
                                                    name="co_applicant_marital_status">
                                                    <option value="">Select Status</option>
                                                    @if (isset($dropdownFields['marital_status']))
                                                        @foreach ($dropdownFields['marital_status']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('co_applicant_marital_status') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_spouse_name" class="form-label">Spouse
                                                    Name</label>
                                                <input type="text" class="form-control" id="co_applicant_spouse_name"
                                                    name="co_applicant_spouse_name"
                                                    value="{{ old('co_applicant_spouse_name') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Identity Documents -->
                                    <h4 class="mt-4">Identity Documents</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_pan" class="form-label">PAN</label>
                                                <input type="text" class="form-control" id="co_applicant_pan"
                                                    name="co_applicant_pan" value="{{ old('co_applicant_pan') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_pan_verified" class="form-label">PAN
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_pan_verified"
                                                    name="co_applicant_pan_verified">
                                                    <option value="0"
                                                        {{ old('co_applicant_pan_verified') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('co_applicant_pan_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_aadhaar" class="form-label">Aadhaar</label>
                                                <input type="text" class="form-control" id="co_applicant_aadhaar"
                                                    name="co_applicant_aadhaar"
                                                    value="{{ old('co_applicant_aadhaar') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_aadhaar_verified" class="form-label">Aadhaar
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_aadhaar_verified"
                                                    name="co_applicant_aadhaar_verified">
                                                    <option value="0"
                                                        {{ old('co_applicant_aadhaar_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('co_applicant_aadhaar_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_form_60" class="form-label">Form 60</label>
                                                <select class="form-select" id="co_applicant_form_60"
                                                    name="co_applicant_form_60">
                                                    <option value="0"
                                                        {{ old('co_applicant_form_60') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('co_applicant_form_60') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_voter_id" class="form-label">Voter ID</label>
                                                <input type="text" class="form-control" id="co_applicant_voter_id"
                                                    name="co_applicant_voter_id"
                                                    value="{{ old('co_applicant_voter_id') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_voter_id_verified" class="form-label">Voter ID
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_voter_id_verified"
                                                    name="co_applicant_voter_id_verified">
                                                    <option value="0"
                                                        {{ old('co_applicant_voter_id_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('co_applicant_voter_id_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_driving_license" class="form-label">Driving
                                                    License</label>
                                                <input type="text" class="form-control"
                                                    id="co_applicant_driving_license" name="co_applicant_driving_license"
                                                    value="{{ old('co_applicant_driving_license') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_driving_license_verified" class="form-label">DL
                                                    Verified</label>
                                                <select class="form-select" id="co_applicant_driving_license_verified"
                                                    name="co_applicant_driving_license_verified">
                                                    <option value="0"
                                                        {{ old('co_applicant_driving_license_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('co_applicant_driving_license_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="co_applicant_passport" class="form-label">Passport</label>
                                                <input type="text" class="form-control" id="co_applicant_passport"
                                                    name="co_applicant_passport"
                                                    value="{{ old('co_applicant_passport') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div id="additionalCoApplicants">
                                        @php
                                            $coApplicantCount = 1;
                                            // Check for additional co-applicants in old data
                                            while (old('co_applicant_' . ($coApplicantCount + 1) . '_first_name')) {
                                                $coApplicantCount++;
                                            }
                                        @endphp

                                        @for ($i = 2; $i <= $coApplicantCount; $i++)
                                            <div class="additional-co-applicant">
                                                <hr class="my-4">
                                                <h4 class="mt-4">Co-Applicant {{ $i }} <button
                                                        type="button"
                                                        class="btn btn-danger btn-sm ms-2 removeCoApplicant">Remove</button>
                                                </h4>
                                                <h5 class="mt-3">Basic Information</h5>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">First
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_first_name"
                                                                value="{{ old('co_applicant_' . $i . '_first_name') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Middle
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_middle_name"
                                                                value="{{ old('co_applicant_' . $i . '_middle_name') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Last
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_last_name"
                                                                value="{{ old('co_applicant_' . $i . '_last_name') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Father
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_father_name"
                                                                value="{{ old('co_applicant_' . $i . '_father_name') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Caste</label><select
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_caste">
                                                                <option value="">Select Caste</option>
                                                                @if (isset($dropdownFields['caste']))
                                                                    @foreach ($dropdownFields['caste']->options as $option)
                                                                        <option value="{{ $option->id }}"
                                                                            {{ old('co_applicant_' . $i . '_caste') == $option->id ? 'selected' : '' }}>
                                                                            {{ $option->option_value }}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">DOB</label><input
                                                                type="date" class="form-control"
                                                                name="co_applicant_{{ $i }}_dob"
                                                                value="{{ old('co_applicant_' . $i . '_dob') }}"></div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Age</label><input
                                                                type="number" class="form-control"
                                                                name="co_applicant_{{ $i }}_age"
                                                                value="{{ old('co_applicant_' . $i . '_age') }}"></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Gender</label><select
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_gender">
                                                                <option value="">Select Gender</option>
                                                                @if (isset($dropdownFields['gender']))
                                                                    @foreach ($dropdownFields['gender']->options as $option)
                                                                        <option value="{{ $option->id }}"
                                                                            {{ old('co_applicant_' . $i . '_gender') == $option->id ? 'selected' : '' }}>
                                                                            {{ $option->option_value }}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h5 class="mt-4">Contact Information</h5>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Contact
                                                                Number</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_contact_number"
                                                                value="{{ old('co_applicant_' . $i . '_contact_number') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Contact
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_contact_verified">
                                                                <option value="0"
                                                                    {{ old('co_applicant_' . $i . '_contact_verified') == '0' ? 'selected' : '' }}>
                                                                    No</option>
                                                                <option value="1"
                                                                    {{ old('co_applicant_' . $i . '_contact_verified') == '1' ? 'selected' : '' }}>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Email</label><input type="email"
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_email"
                                                                value="{{ old('co_applicant_' . $i . '_email') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Address
                                                                Type</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_address_type">
                                                                <option value="">Select Type</option>
                                                                @if (isset($dropdownFields['address_type']))
                                                                    @foreach ($dropdownFields['address_type']->options as $option)
                                                                        <option value="{{ $option->id }}"
                                                                            {{ old('co_applicant_' . $i . '_address_type') == $option->id ? 'selected' : '' }}>
                                                                            {{ $option->option_value }}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Pincode</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_current_pincode"
                                                                value="{{ old('co_applicant_' . $i . '_current_pincode') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Current
                                                                State</label><select
                                                                class="form-control co-applicant-state-select"
                                                                name="co_applicant_{{ $i }}_current_state"
                                                                data-target="co_applicant_{{ $i }}_current_city">
                                                                <option value="">Select State</option>
                                                                @foreach ($states as $state)
                                                                    <option value="{{ $state->id }}"
                                                                        {{ old('co_applicant_' . $i . '_current_state') == $state->id ? 'selected' : '' }}>
                                                                        {{ $state->name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Current
                                                                City</label><select
                                                                class="form-control co-applicant-city-select"
                                                                name="co_applicant_{{ $i }}_current_city"
                                                                id="co_applicant_{{ $i }}_current_city">
                                                                <option value="">Select City</option>
                                                                @if (old('co_applicant_' . $i . '_current_state'))
                                                                    @foreach ($cities->where('state_id', old('co_applicant_' . $i . '_current_state')) as $city)
                                                                        <option value="{{ $city->id }}"
                                                                            {{ old('co_applicant_' . $i . '_current_city') == $city->id ? 'selected' : '' }}>
                                                                            {{ $city->name }}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Current
                                                                Address</label>
                                                            <textarea class="form-control" name="co_applicant_{{ $i }}_current_address" rows="1">{{ old('co_applicant_' . $i . '_current_address') }}</textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Place of
                                                                Birth</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_place_of_birth"
                                                                value="{{ old('co_applicant_' . $i . '_place_of_birth') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Nationality</label><select
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_nationality">
                                                                <option value="">Select Nationality</option>
                                                                @if (isset($dropdownFields['nationality']))
                                                                    @foreach ($dropdownFields['nationality']->options as $option)
                                                                        <option value="{{ $option->id }}"
                                                                            {{ old('co_applicant_' . $i . '_nationality') == $option->id ? 'selected' : '' }}>
                                                                            {{ $option->option_value }}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Marital
                                                                Status</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_marital_status">
                                                                <option value="">Select Status</option>
                                                                @if (isset($dropdownFields['marital_status']))
                                                                    @foreach ($dropdownFields['marital_status']->options as $option)
                                                                        <option value="{{ $option->id }}"
                                                                            {{ old('co_applicant_' . $i . '_marital_status') == $option->id ? 'selected' : '' }}>
                                                                            {{ $option->option_value }}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Spouse
                                                                Name</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_spouse_name"
                                                                value="{{ old('co_applicant_' . $i . '_spouse_name') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <h5 class="mt-4">Identity Documents</h5>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">PAN</label><input
                                                                type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_pan"
                                                                value="{{ old('co_applicant_' . $i . '_pan') }}"></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">PAN
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_pan_verified">
                                                                <option value="0"
                                                                    {{ old('co_applicant_' . $i . '_pan_verified') == '0' ? 'selected' : '' }}>
                                                                    No</option>
                                                                <option value="1"
                                                                    {{ old('co_applicant_' . $i . '_pan_verified') == '1' ? 'selected' : '' }}>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Aadhaar</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_aadhaar"
                                                                value="{{ old('co_applicant_' . $i . '_aadhaar') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Aadhaar
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_aadhaar_verified">
                                                                <option value="0"
                                                                    {{ old('co_applicant_' . $i . '_aadhaar_verified') == '0' ? 'selected' : '' }}>
                                                                    No</option>
                                                                <option value="1"
                                                                    {{ old('co_applicant_' . $i . '_aadhaar_verified') == '1' ? 'selected' : '' }}>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Form
                                                                60</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_form_60">
                                                                <option value="0"
                                                                    {{ old('co_applicant_' . $i . '_form_60') == '0' ? 'selected' : '' }}>
                                                                    No</option>
                                                                <option value="1"
                                                                    {{ old('co_applicant_' . $i . '_form_60') == '1' ? 'selected' : '' }}>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Voter
                                                                ID</label><input type="text" class="form-control"
                                                                name="co_applicant_{{ $i }}_voter_id"
                                                                value="{{ old('co_applicant_' . $i . '_voter_id') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Voter ID
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_voter_id_verified">
                                                                <option value="0"
                                                                    {{ old('co_applicant_' . $i . '_voter_id_verified') == '0' ? 'selected' : '' }}>
                                                                    No</option>
                                                                <option value="1"
                                                                    {{ old('co_applicant_' . $i . '_voter_id_verified') == '1' ? 'selected' : '' }}>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">Driving
                                                                License</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_driving_license"
                                                                value="{{ old('co_applicant_' . $i . '_driving_license') }}">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label class="form-label">DL
                                                                Verified</label><select class="form-control"
                                                                name="co_applicant_{{ $i }}_driving_license_verified">
                                                                <option value="0"
                                                                    {{ old('co_applicant_' . $i . '_driving_license_verified') == '0' ? 'selected' : '' }}>
                                                                    No</option>
                                                                <option value="1"
                                                                    {{ old('co_applicant_' . $i . '_driving_license_verified') == '1' ? 'selected' : '' }}>
                                                                    Yes</option>
                                                            </select></div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="mb-3"><label
                                                                class="form-label">Passport</label><input type="text"
                                                                class="form-control"
                                                                name="co_applicant_{{ $i }}_passport"
                                                                value="{{ old('co_applicant_' . $i . '_passport') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endfor
                                    </div>
                                </section>












                                <!--Guarantor Basic Information -->
                                <h1 class="mt-5">Guarantor Details <button type="button"
                                        class="btn btn-primary btn-sm ms-3" id="toggleGuarantor">Add Guarantor</button>
                                </h1>
                                <section id="guarantor_section" style="display: none;">
                                    <h4 class="mt-3">Basic Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_first_name" class="form-label">First Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="guarantor_first_name"
                                                    name="guarantor_first_name"
                                                    value="{{ old('guarantor_first_name') }}">
                                                @error('guarantor_first_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_middle_name" class="form-label">Middle
                                                    Name</label>
                                                <input type="text" class="form-control" id="guarantor_middle_name"
                                                    name="guarantor_middle_name"
                                                    value="{{ old('guarantor_middle_name') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_last_name" class="form-label">Last Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="guarantor_last_name"
                                                    name="guarantor_last_name"
                                                    value="{{ old('guarantor_last_name') }}">
                                                @error('guarantor_last_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_father_name" class="form-label">Father Name <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" id="guarantor_father_name"
                                                    name="guarantor_father_name"
                                                    value="{{ old('guarantor_father_name') }}">
                                                @error('guarantor_father_name')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_caste" class="form-label">Caste</label>
                                                <select class="form-select" id="guarantor_caste"
                                                    name="guarantor_caste">
                                                    <option value="">Select Caste</option>
                                                    @if (isset($dropdownFields['caste']))
                                                        @foreach ($dropdownFields['caste']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('guarantor_caste') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_dob" class="form-label">DOB</label>
                                                <input type="date" class="form-control" id="guarantor_dob"
                                                    name="guarantor_dob" value="{{ old('guarantor_dob') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_age" class="form-label">Age</label>
                                                <input type="number" class="form-control" id="guarantor_age"
                                                    name="guarantor_age" value="{{ old('guarantor_age') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_gender" class="form-label">Gender</label>
                                                <select class="form-select" id="guarantor_gender"
                                                    name="guarantor_gender">
                                                    <option value="">Select Gender</option>
                                                    @if (isset($dropdownFields['gender']))
                                                        @foreach ($dropdownFields['gender']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('guarantor_gender') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

 <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_image" class="form-label">Guarantor Image</label>
                                                <input type="file" class="form-control" id="guarantor_image"
                                                    name="guarantor_image" accept="image/*">
                                            </div>
                                        </div>

                                    </div>

                                    <!-- Contact Information -->
                                    <h4 class="mt-4">Contact Information</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_contact_number" class="form-label">Contact Number
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_contact_number" name="guarantor_contact_number"
                                                    value="{{ old('guarantor_contact_number') }}">
                                                @error('guarantor_contact_number')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_contact_verified" class="form-label">Contact
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_contact_verified"
                                                    name="guarantor_contact_verified">
                                                    <option value="0"
                                                        {{ old('guarantor_contact_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('guarantor_contact_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_email" class="form-label">Email</label>
                                                <input type="email" class="form-control" id="guarantor_email"
                                                    name="guarantor_email" value="{{ old('guarantor_email') }}">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_address_type" class="form-label">Address
                                                    Type</label>
                                                <select class="form-select" id="guarantor_address_type"
                                                    name="guarantor_address_type">
                                                    <option value="">Select Type</option>
                                                    @if (isset($dropdownFields['address_type']))
                                                        @foreach ($dropdownFields['address_type']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('guarantor_address_type') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_pincode" class="form-label">Pincode <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_current_pincode" name="guarantor_current_pincode"
                                                    value="{{ old('guarantor_current_pincode') }}">
                                                @error('guarantor_current_pincode')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_state" class="form-label">Current
                                                    State</label>
                                                <select class="form-control guarantor-state-select"
                                                    id="guarantor_current_state" name="guarantor_current_state"
                                                    data-target="guarantor_current_city">
                                                    <option value="">Select State</option>
                                                    @foreach ($states as $state)
                                                        <option value="{{ $state->id }}"
                                                            {{ old('guarantor_current_state') == $state->id ? 'selected' : '' }}>
                                                            {{ $state->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_city" class="form-label">Current
                                                    City</label>
                                                <select class="form-control guarantor-city-select"
                                                    id="guarantor_current_city" name="guarantor_current_city">
                                                    <option value="">Select City</option>
                                                    @if (old('guarantor_current_state'))
                                                        @foreach ($cities->where('state_id', old('guarantor_current_state')) as $city)
                                                            <option value="{{ $city->id }}"
                                                                {{ old('guarantor_current_city') == $city->id ? 'selected' : '' }}>
                                                                {{ $city->name }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>



                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_current_address" class="form-label">Current
                                                    Address <span class="text-danger"></span></label>
                                                <textarea class="form-control" id="guarantor_current_address" name="guarantor_current_address" rows="1">{{ old('guarantor_current_address') }}</textarea>
                                                @error('guarantor_current_address')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_place_of_birth" class="form-label">Place of Birth
                                                    <span class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_place_of_birth" name="guarantor_place_of_birth"
                                                    value="{{ old('guarantor_place_of_birth') }}">
                                                @error('guarantor_place_of_birth')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_nationality"
                                                    class="form-label">Nationality</label>
                                                <select class="form-select" id="guarantor_nationality"
                                                    name="guarantor_nationality">
                                                    <option value="">Select Nationality</option>
                                                    @if (isset($dropdownFields['nationality']))
                                                        @foreach ($dropdownFields['nationality']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('guarantor_nationality') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_marital_status" class="form-label">Marital
                                                    Status</label>
                                                <select class="form-select" id="guarantor_marital_status"
                                                    name="guarantor_marital_status">
                                                    <option value="">Select Status</option>
                                                    @if (isset($dropdownFields['marital_status']))
                                                        @foreach ($dropdownFields['marital_status']->options as $option)
                                                            <option value="{{ $option->id }}"
                                                                {{ old('guarantor_marital_status') == $option->id ? 'selected' : '' }}>
                                                                {{ $option->option_value }}
                                                            </option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_spouse_name" class="form-label">Spouse
                                                    Name</label>
                                                <input type="text" class="form-control" id="guarantor_spouse_name"
                                                    name="guarantor_spouse_name"
                                                    value="{{ old('guarantor_spouse_name') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Identity Documents -->
                                    <h4 class="mt-4">Identity Documents</h4>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_pan" class="form-label">PAN</label>
                                                <input type="text" class="form-control" id="guarantor_pan"
                                                    name="guarantor_pan" value="{{ old('guarantor_pan') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_pan_verified" class="form-label">PAN
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_pan_verified"
                                                    name="guarantor_pan_verified">
                                                    <option value="0"
                                                        {{ old('guarantor_pan_verified') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('guarantor_pan_verified') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_aadhaar" class="form-label">Aadhaar</label>
                                                <input type="text" class="form-control" id="guarantor_aadhaar"
                                                    name="guarantor_aadhaar" value="{{ old('guarantor_aadhaar') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_aadhaar_verified" class="form-label">Aadhaar
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_aadhaar_verified"
                                                    name="guarantor_aadhaar_verified">
                                                    <option value="0"
                                                        {{ old('guarantor_aadhaar_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('guarantor_aadhaar_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_form_60" class="form-label">Form 60</label>
                                                <select class="form-select" id="guarantor_form_60"
                                                    name="guarantor_form_60">
                                                    <option value="0"
                                                        {{ old('guarantor_form_60') == '0' ? 'selected' : '' }}>No
                                                    </option>
                                                    <option value="1"
                                                        {{ old('guarantor_form_60') == '1' ? 'selected' : '' }}>Yes
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_voter_id" class="form-label">Voter ID</label>
                                                <input type="text" class="form-control" id="guarantor_voter_id"
                                                    name="guarantor_voter_id" value="{{ old('guarantor_voter_id') }}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">

                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_voter_id_verified" class="form-label">Voter ID
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_voter_id_verified"
                                                    name="guarantor_voter_id_verified">
                                                    <option value="0"
                                                        {{ old('guarantor_voter_id_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('guarantor_voter_id_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_driving_license" class="form-label">Driving
                                                    License</label>
                                                <input type="text" class="form-control"
                                                    id="guarantor_driving_license" name="guarantor_driving_license"
                                                    value="{{ old('guarantor_driving_license') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_driving_license_verified" class="form-label">DL
                                                    Verified</label>
                                                <select class="form-select" id="guarantor_driving_license_verified"
                                                    name="guarantor_driving_license_verified">
                                                    <option value="0"
                                                        {{ old('guarantor_driving_license_verified') == '0' ? 'selected' : '' }}>
                                                        No</option>
                                                    <option value="1"
                                                        {{ old('guarantor_driving_license_verified') == '1' ? 'selected' : '' }}>
                                                        Yes</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="guarantor_passport" class="form-label">Passport</label>
                                                <input type="text" class="form-control" id="guarantor_passport"
                                                    name="guarantor_passport" value="{{ old('guarantor_passport') }}">
                                            </div>
                                        </div>
                                    </div>
                                </section>










                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Create Lead</button>
                                        <a href="{{ route('dashboard') }}" class="btn btn-secondary">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Pass data to JavaScript
        window.usersData = @json($users);
        window.relationOptions = `
            @if (isset($dropdownFields['relation_with_applicant']))
                @foreach ($dropdownFields['relation_with_applicant']->options as $option)
                    <option value="{{ $option->id }}">{{ $option->option_value }}</option>
                @endforeach
            @endif
        `;
        window.stateOptions = `
            @foreach ($states as $state)
                <option value="{{ $state->id }}">{{ $state->name }}</option>
            @endforeach
        `;
        window.casteOptions = `
            @if (isset($dropdownFields['caste']))
                @foreach ($dropdownFields['caste']->options as $option)
                    <option value="{{ $option->id }}">{{ $option->option_value }}</option>
                @endforeach
            @endif
        `;
        window.genderOptions = `
            @if (isset($dropdownFields['gender']))
                @foreach ($dropdownFields['gender']->options as $option)
                    <option value="{{ $option->id }}">{{ $option->option_value }}</option>
                @endforeach
            @endif
        `;
        window.addressTypeOptions = `
            @if (isset($dropdownFields['address_type']))
                @foreach ($dropdownFields['address_type']->options as $option)
                    <option value="{{ $option->id }}">{{ $option->option_value }}</option>
                @endforeach
            @endif
        `;
        window.nationalityOptions = `
            @if (isset($dropdownFields['nationality']))
                @foreach ($dropdownFields['nationality']->options as $option)
                    <option value="{{ $option->id }}">{{ $option->option_value }}</option>
                @endforeach
            @endif
        `;
        window.maritalStatusOptions = `
            @if (isset($dropdownFields['marital_status']))
                @foreach ($dropdownFields['marital_status']->options as $option)
                    <option value="{{ $option->id }}">{{ $option->option_value }}</option>
                @endforeach
            @endif
        `;

        // Calculate reference count from old values
        @php
            $oldReferenceCount = 0;
            foreach (old() as $key => $value) {
                if (str_starts_with($key, 'reference_') && !str_contains($key, '_relation_id') && !str_contains($key, '_contact_no') && !empty($value)) {
                    $oldReferenceCount++;
                }
            }

            $oldCoApplicantCount = 1;
            while (old('co_applicant_' . ($oldCoApplicantCount + 1) . '_first_name')) {
                $oldCoApplicantCount++;
            }
        @endphp
        window.oldReferences = {{ max(1, $oldReferenceCount) }};
        window.oldCoApplicantCount = {{ $oldCoApplicantCount }};

        // Section visibility based on old values
        window.oldCoApplicantVisible = {{ old('co_applicant_first_name') ? 'true' : 'false' }};
        window.oldGuarantorVisible = {{ old('guarantor_first_name') ? 'true' : 'false' }};
    </script>
    <script src="{{ asset('assets/js/pages/lead-create.js') }}"></script>
@endsection
