@extends('layout.layout')
@section('content')
    <style>
        label {
            margin-bottom: 0px !important;
        }

        .accordion {
            margin-bottom: 5px;
        }

        .img-thumbnail {
            cursor: pointer;
            position: relative;
        }

        .img-preview {
            position: absolute;
            z-index: 1000;
            border: 2px solid #fff;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            display: none;
            pointer-events: none;
        }
    </style>

    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">View Lead Details</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Lead Management</a></li>
                                <li class="breadcrumb-item active">View Lead</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Applicant Lead Information</h4>
                        </div>
                        <div class="card-body">
                            <!-- Basic Information -->
                            <div class="accordion" id="applicantAccordion">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="applicantHeading">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#applicantCollapse" aria-expanded="false"
                                            aria-controls="applicantCollapse">
                                            Applicant Details
                                        </button>
                                    </h2>
                                    <div class="px-3 py-2 bg-light border-bottom">
                                        <div class="row text-muted small">
                                            <div class="col-md-1">
                                                @if ($applicant->applicant_image)
                                                    <img src="{{ asset('storage/uploads/applicants/' . $applicant->applicant_image) }}"
                                                        alt="Applicant Image" class="img-thumbnail image-hover"
                                                        style="width: 35px; height: 35px;"
                                                        onclick="window.open(this.src, '_blank')">
                                                @else
                                                    <span class="text-muted">No Image</span>
                                                @endif
                                            </div>
                                            <div class="col-md-3">
                                                <strong>Applicant:</strong> {{ $applicant->applicant_first_name ?? 'N/A' }}
                                                {{ $applicant->applicant_middle_name ?? '' }}
                                                {{ $applicant->applicant_last_name ?? 'N/A' }}
                                            </div>


                                            <div class="col-md-2">
                                                <strong>Loan Type:</strong>
                                                {{ $dropdownFields['loan_type']->options->where('id', $applicant->loan_type)->first()->option_value ?? 'N/A' }}
                                            </div>

                                            <div class="col-md-1">
                                                <strong>Age:</strong> {{ $applicant->age ?? 'N/A' }}
                                            </div>
                                            <div class="col-md-1">
                                                <strong>Gender:</strong>
                                                {{ $dropdownFields['gender']->options->where('id', $applicant->gender)->first()->option_value ?? 'N/A' }}
                                            </div>
                                            <div class="col-md-2">
                                                <strong>Contact:</strong> {{ $applicant->contact_number ?? 'N/A' }}
                                            </div>
                                            <div class="col-md-2">
                                                <strong>Email:</strong> {{ $applicant->email ?? 'N/A' }}
                                            </div>
                                        </div>
                                    </div>
                                    <div id="applicantCollapse" class="accordion-collapse collapse"
                                        aria-labelledby="applicantHeading" data-bs-parent="#applicantAccordion">
                                        <div class="accordion-body">
                                            <section id="view_applicant_details">
                                                <h4 class="mt-3">Basic Information</h4>
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Segment:</label>
                                                            <p>{{ $dropdownFields['segment']->options->where('id', $applicant->segment)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Loan Type:</label>
                                                            <p>{{ $dropdownFields['loan_type']->options->where('id', $applicant->loan_type)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Customer Type:</label>
                                                            <p>{{ $dropdownFields['customer_type']->options->where('id', $applicant->customer_type)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">First Name:</label>
                                                            <p>{{ $applicant->applicant_first_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Middle Name:</label>
                                                            <p>{{ $applicant->applicant_middle_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Last Name:</label>
                                                            <p>{{ $applicant->applicant_last_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Father Name:</label>
                                                            <p>{{ $applicant->father_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Caste:</label>
                                                            <p>{{ $dropdownFields['caste']->options->where('id', $applicant->caste)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">DOB:</label>
                                                            <p>{{ $applicant->dob ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Age:</label>
                                                            <p>{{ $applicant->age ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Gender:</label>
                                                            <p>{{ $dropdownFields['gender']->options->where('id', $applicant->gender)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Contact Information -->
                                                <h4 class="mt-4">Contact Information</h4>
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Contact Number:</label>
                                                            <p>{{ $applicant->contact_number ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Contact Verified:</label>
                                                            <p>{{ $applicant->contact_verified == '1' ? 'Yes' : 'No' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Email:</label>
                                                            <p>{{ $applicant->email ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Address Type:</label>
                                                            <p>{{ $dropdownFields['address_type']->options->where('id', $applicant->address_type)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Pincode:</label>
                                                            <p>{{ $applicant->current_pincode ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Current State:</label>
                                                            <p>{{ $applicant->current_state ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Current City:</label>
                                                            <p>{{ $applicant->current_city ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Current Address:</label>
                                                            <p>{{ $applicant->current_address ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Place of Birth:</label>
                                                            <p>{{ $applicant->place_of_birth ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Nationality:</label>
                                                            <p>{{ $dropdownFields['nationality']->options->where('id', $applicant->nationality)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Marital Status:</label>
                                                            <p>{{ $dropdownFields['marital_status']->options->where('id', $applicant->marital_status)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Spouse Name:</label>
                                                            <p>{{ $applicant->spouse_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <h4 class="mt-4">Identity Documents</h4>
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">PAN:</label>
                                                            <p>{{ $applicant->pan ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">PAN Verified:</label>
                                                            <p>{{ $applicant->pan_verified == '1' ? 'Yes' : 'No' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Aadhaar:</label>
                                                            <p>{{ $applicant->aadhaar ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Aadhaar Verified:</label>
                                                            <p>{{ $applicant->aadhaar_verified == '1' ? 'Yes' : 'No' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Form 60:</label>
                                                            <p>{{ $applicant->form_60 == '1' ? 'Yes' : 'No' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Voter ID:</label>
                                                            <p>{{ $applicant->voter_id ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Voter ID Verified:</label>
                                                            <p>{{ $applicant->voter_id_verified == '1' ? 'Yes' : 'No' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Driving License:</label>
                                                            <p>{{ $applicant->driving_license ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">DL Verified:</label>
                                                            <p>{{ $applicant->driving_license_verified == '1' ? 'Yes' : 'No' }}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Passport:</label>
                                                            <p>{{ $applicant->passport ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <h4 class="mt-4">Banking & References</h4>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Banking Info:</label>
                                                            <p>{{ $dropdownFields['banking_info']->options->where('id', $applicant->banking_info)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                @if ($applicant->references->count() > 0)
                                                    <h5 class="mt-3">References</h5>
                                                    @foreach ($applicant->references as $index => $reference)
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Reference
                                                                        {{ $index + 1 }}
                                                                        Name:</label>
                                                                    <p>{{ $reference->name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Contact
                                                                        Number:</label>
                                                                    <p>{{ $reference->contact_no ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Relation:</label>
                                                                    <p>{{ $reference->relation_with_applicant ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <p class="text-muted">No references available</p>
                                                @endif

                                                <h4 class="mt-4">Loan Information</h4>
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Login Date:</label>
                                                            <p>{{ $applicant->login_date ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Login Amount:</label>
                                                            <p>{{ $applicant->login_amount ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Tenure:</label>
                                                            <p>{{ $dropdownFields['tenure']->options->where('id', $applicant->tenure)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">ROI:</label>
                                                            <p>{{ $applicant->roi ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Branch:</label>
                                                            <p>{{ $applicant->branch->branch_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">BM Name:</label>
                                                            <p>{{ $applicant->bmUser->name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">RM Name:</label>
                                                            <p>{{ $applicant->rm_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <h4 class="mt-4">BT/IMD Information</h4>
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">BT (Yes/No):</label>
                                                            <p>{{ $applicant->bt_yes_no_id == '1' ? 'Yes' : 'No' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">BT Company Name:</label>
                                                            <p>{{ $applicant->bt_company_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">IMD Waiver:</label>
                                                            <p>{{ $dropdownFields['imd_waiver']->options->where('id', $applicant->imd_waiver)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">IMD Transaction Ref:</label>
                                                            <p>{{ $applicant->imd_transaction_ref ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <h4 class="mt-4">Business Information</h4>
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Business Address:</label>
                                                            <p>{{ $applicant->business_address ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Annual Income:</label>
                                                            <p>{{ $applicant->annual_income ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Obligation:</label>
                                                            <p>{{ $applicant->obligation ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">FOIR:</label>
                                                            <p>{{ $applicant->foir ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">LTV:</label>
                                                            <p>{{ $applicant->ltv ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">GPS Tagging:</label>
                                                            <p>{{ $applicant->gps_tagging ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Property Type:</label>
                                                            <p>{{ $dropdownFields['property_type']->options->where('id', $applicant->property_type)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Property Owner Name:</label>
                                                            <p>{{ $applicant->property_owner_name ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Property Address:</label>
                                                            <p>{{ $applicant->property_address ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <h4 class="mt-4">PSL Information</h4>
                                                <div class="row">
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">PSL (Yes/No):</label>
                                                            <p>{{ $applicant->psl_yes_no_id == '1' ? 'Yes' : 'No' }}</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Manufacturing:</label>
                                                            <p>{{ $dropdownFields['manufacturing_service_agriculture']->options->where('id', $applicant->manufacturing_service_agriculture)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">PSL Sub Category:</label>
                                                            <p>{{ $dropdownFields['psl_sub_category']->options->where('id', $applicant->psl_sub_category)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Purpose of Loans:</label>
                                                            <p>{{ $dropdownFields['purpose_of_loans']->options->where('id', $applicant->purpose_of_loans)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">PSL Document Type:</label>
                                                            <p>{{ $dropdownFields['psl_document_type']->options->where('id', $applicant->psl_document_type)->first()->option_value ?? 'N/A' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">PSL Document Number:</label>
                                                            <p>{{ $applicant->psl_document_number ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Field Investigation
                                                                Flag:</label>
                                                            <p>{{ $applicant->field_investigation_flag == '1' ? 'Yes' : 'No' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Tele Verification
                                                                Flag:</label>
                                                            <p>{{ $applicant->tele_verification_flag == '1' ? 'Yes' : 'No' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Personal Discussion
                                                                Flag:</label>
                                                            <p>{{ $applicant->personal_discussion_flag == '1' ? 'Yes' : 'No' }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <h4 class="mt-4">Defaults</h4>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Lead Status:</label>
                                                            <p>
                                                                @switch($applicant->status)
                                                                    @case(1)
                                                                        New
                                                                    @break

                                                                    @case(2)
                                                                        RO Assigned
                                                                    @break

                                                                    @case(3)
                                                                        RO Verified
                                                                    @break

                                                                    @case(4)
                                                                        Branch Review
                                                                    @break

                                                                      @case(5)
                                                                        Branch Approved
                                                                    @break

                                                                    @case(6)
                                                                        Bank wise approve
                                                                    @break

                                                                    @case(7)
                                                                        Final Lead source
                                                                    @break

                                                                    @case(90)
                                                                        Cancelled
                                                                    @break

                                                                    @case(91)
                                                                        Other
                                                                    @break

                                                                    @default
                                                                        Unknown
                                                                @endswitch
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="mb-3">
                                                            <label class="form-label fw-bold">Lead Assign To:</label>
                                                            <p>{{ $applicant->assignedTo->name ?? 'Not Assigned' }}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </section>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            @if ($applicant->coApplicants->count() > 0)
                                <div class="accordion" id="coApplicantAccordion">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="coApplicantHeading">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#coApplicantCollapse"
                                                aria-expanded="false" aria-controls="coApplicantCollapse">
                                                CO Applicant Details
                                            </button>
                                        </h2>
                                        <div class="px-3 py-2 bg-light border-bottom">
                                            @foreach ($applicant->coApplicants as $index => $coApplicant)
                                                <div class="row text-muted small mb-2">
                                                    <div class="col-md-1">
                                                        @if ($coApplicant->co_applicant_image)
                                                            <img src="{{ asset('storage/uploads/co_applicants/' . $coApplicant->co_applicant_image) }}"
                                                                alt="Co-Applicant Image" class="img-thumbnail image-hover"
                                                                style="width: 35px; height: 35px;"
                                                                onclick="window.open(this.src, '_blank')">
                                                        @else
                                                            <span class="text-muted">No Image</span>
                                                        @endif
                                                    </div>
                                                    <div class="col-md-3">
                                                        <strong>Co Applicants {{ $index + 1 }} :</strong>

                                                        {{ $coApplicant->co_applicant_first_name ?? 'N/A' }}
                                                        {{ $coApplicant->applicant_middle_name ?? '' }}
                                                        {{ $coApplicant->applicant_last_name ?? 'N/A' }}
                                                    </div>

                                                    <div class="col-md-1">
                                                        <strong>Age:</strong> {{ $coApplicant->age ?? 'N/A' }}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <strong>Gender:</strong>
                                                        {{ $dropdownFields['gender']->options->where('id', $coApplicant->gender_id)->first()->option_value ?? 'N/A' }}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <strong>Contact:</strong>
                                                        {{ $coApplicant->contact_number ?? 'N/A' }}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <strong>Email:</strong> {{ $coApplicant->email ?? 'N/A' }}
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div id="coApplicantCollapse" class="accordion-collapse collapse"
                                            aria-labelledby="coApplicantHeading" data-bs-parent="#coApplicantAccordion">
                                            <div class="accordion-body">
                                                <section id="view_co_applicant_details">
                                                    @foreach ($applicant->coApplicants as $index => $coApplicant)
                                                        <h4 class="mt-3">Co-Applicant {{ $index + 1 }} - Basic
                                                            Information</h4>
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">First Name:</label>
                                                                    <p>{{ $coApplicant->co_applicant_first_name ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Middle Name:</label>
                                                                    <p>{{ $coApplicant->applicant_middle_name ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Last Name:</label>
                                                                    <p>{{ $coApplicant->applicant_last_name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Father Name:</label>
                                                                    <p>{{ $coApplicant->father_name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Caste:</label>
                                                                    <p>{{ $dropdownFields['caste']->options->where('id', $coApplicant->caste_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">DOB:</label>
                                                                    <p>{{ $coApplicant->dob ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Age:</label>
                                                                    <p>{{ $coApplicant->age ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Gender:</label>
                                                                    <p>{{ $dropdownFields['gender']->options->where('id', $coApplicant->gender_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <h4 class="mt-4">Contact Information</h4>
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Contact
                                                                        Number:</label>
                                                                    <p>{{ $coApplicant->contact_number ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Email:</label>
                                                                    <p>{{ $coApplicant->email ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Address Type:</label>
                                                                    <p>{{ $dropdownFields['address_type']->options->where('id', $coApplicant->address_type_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Pincode:</label>
                                                                    <p>{{ $coApplicant->current_pincode ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Current
                                                                        State:</label>
                                                                    <p>{{ $coApplicant->current_state ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Current City:</label>
                                                                    <p>{{ $coApplicant->current_city ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Current
                                                                        Address:</label>
                                                                    <p>{{ $coApplicant->current_address ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Place of
                                                                        Birth:</label>
                                                                    <p>{{ $coApplicant->place_of_birth ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Nationality:</label>
                                                                    <p>{{ $dropdownFields['nationality']->options->where('id', $coApplicant->nationality)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Marital
                                                                        Status:</label>
                                                                    <p>{{ $dropdownFields['marital_status']->options->where('id', $coApplicant->marital_status_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Spouse Name:</label>
                                                                    <p>{{ $coApplicant->spouse_name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <h4 class="mt-4">Identity Documents</h4>
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">PAN:</label>
                                                                    <p>{{ $coApplicant->pan ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">PAN Verified:</label>
                                                                    <p>{{ $coApplicant->pan_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Aadhaar:</label>
                                                                    <p>{{ $coApplicant->aadhaar ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Aadhaar
                                                                        Verified:</label>
                                                                    <p>{{ $coApplicant->aadhaar_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Form 60:</label>
                                                                    <p>{{ $coApplicant->form_60 == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Voter ID:</label>
                                                                    <p>{{ $coApplicant->voter_id ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Voter ID
                                                                        Verified:</label>
                                                                    <p>{{ $coApplicant->voter_id_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Driving
                                                                        License:</label>
                                                                    <p>{{ $coApplicant->driving_license ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">DL Verified:</label>
                                                                    <p>{{ $coApplicant->driving_license_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Passport:</label>
                                                                    <p>{{ $coApplicant->passport ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </section>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if ($applicant->guarantors->count() > 0)
                                <div class="accordion" id="guarantorAccordion">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="guarantorHeading">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#guarantorCollapse"
                                                aria-expanded="false" aria-controls="guarantorCollapse">
                                                Guarantor Details
                                            </button>
                                        </h2>
                                        <div class="px-3 py-2 bg-light border-bottom">
                                            @foreach ($applicant->guarantors as $index => $guarantor)
                                                <div class="row text-muted small mb-2">
                                                    <div class="col-md-1">
                                                        @if ($guarantor->applicant_guarantor_image)
                                                            <img src="{{ asset('storage/uploads/guarantors/' . $guarantor->applicant_guarantor_image) }}"
                                                                alt="Guarantor Image" class="img-thumbnail image-hover"
                                                                style="width: 35px; height: 35px;"
                                                                onclick="window.open(this.src, '_blank')">
                                                        @else
                                                            <span class="text-muted">No Image</span>
                                                        @endif
                                                    </div>
                                                    <div class="col-md-3">
                                                        <strong>Guarantor Name:</strong>
                                                        {{ $guarantor->guarantor_first_name ?? 'N/A' }}
                                                        {{ $guarantor->applicant_middle_name ?? '' }}
                                                        {{ $guarantor->applicant_last_name ?? 'N/A' }}
                                                    </div>
                                                    <div class="col-md-1">
                                                        <strong>Age:</strong> {{ $guarantor->age ?? 'N/A' }}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <strong>Gender:</strong>
                                                        {{ $dropdownFields['gender']->options->where('id', $guarantor->gender_id)->first()->option_value ?? 'N/A' }}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <strong>Contact:</strong>
                                                        {{ $guarantor->contact_number ?? 'N/A' }}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <strong>Email:</strong> {{ $guarantor->email ?? 'N/A' }}
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div id="guarantorCollapse" class="accordion-collapse collapse"
                                            aria-labelledby="guarantorHeading" data-bs-parent="#guarantorAccordion">
                                            <div class="accordion-body">
                                                <section id="view_guarantor_details">
                                                    @foreach ($applicant->guarantors as $index => $guarantor)
                                                        <h4 class="mt-3">Guarantor {{ $index + 1 }} - Basic
                                                            Information</h4>
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">First Name:</label>
                                                                    <p>{{ $guarantor->guarantor_first_name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Middle Name:</label>
                                                                    <p>{{ $guarantor->applicant_middle_name ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Last Name:</label>
                                                                    <p>{{ $guarantor->applicant_last_name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Father Name:</label>
                                                                    <p>{{ $guarantor->father_name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Caste:</label>
                                                                    <p>{{ $dropdownFields['caste']->options->where('id', $guarantor->caste_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">DOB:</label>
                                                                    <p>{{ $guarantor->dob ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Age:</label>
                                                                    <p>{{ $guarantor->age ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Gender:</label>
                                                                    <p>{{ $dropdownFields['gender']->options->where('id', $guarantor->gender_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <h4 class="mt-4">Contact Information</h4>
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Contact
                                                                        Number:</label>
                                                                    <p>{{ $guarantor->contact_number ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Email:</label>
                                                                    <p>{{ $guarantor->email ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Address Type:</label>
                                                                    <p>{{ $dropdownFields['address_type']->options->where('id', $guarantor->address_type_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Pincode:</label>
                                                                    <p>{{ $guarantor->current_pincode ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Current
                                                                        State:</label>
                                                                    <p>{{ $guarantor->current_state ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Current City:</label>
                                                                    <p>{{ $guarantor->current_city ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Current
                                                                        Address:</label>
                                                                    <p>{{ $guarantor->current_address ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Place of
                                                                        Birth:</label>
                                                                    <p>{{ $guarantor->place_of_birth ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Nationality:</label>
                                                                    <p>{{ $dropdownFields['nationality']->options->where('id', $guarantor->nationality)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Marital
                                                                        Status:</label>
                                                                    <p>{{ $dropdownFields['marital_status']->options->where('id', $guarantor->marital_status_id)->first()->option_value ?? 'N/A' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Spouse Name:</label>
                                                                    <p>{{ $guarantor->spouse_name ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <h4 class="mt-4">Identity Documents</h4>
                                                        <div class="row">
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">PAN:</label>
                                                                    <p>{{ $guarantor->pan ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">PAN Verified:</label>
                                                                    <p>{{ $guarantor->pan_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Aadhaar:</label>
                                                                    <p>{{ $guarantor->aadhaar ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Aadhaar
                                                                        Verified:</label>
                                                                    <p>{{ $guarantor->aadhaar_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Form 60:</label>
                                                                    <p>{{ $guarantor->form_60 == '1' ? 'Yes' : 'No' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Voter ID:</label>
                                                                    <p>{{ $guarantor->voter_id ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Voter ID
                                                                        Verified:</label>
                                                                    <p>{{ $guarantor->voter_id_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Driving
                                                                        License:</label>
                                                                    <p>{{ $guarantor->driving_license ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">DL Verified:</label>
                                                                    <p>{{ $guarantor->driving_license_verified == '1' ? 'Yes' : 'No' }}
                                                                    </p>
                                                                </div>
                                                            </div>

                                                            <div class="col-md-2">
                                                                <div class="mb-3">
                                                                    <label class="form-label fw-bold">Passport:</label>
                                                                    <p>{{ $guarantor->passport ?? 'N/A' }}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </section>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="mb-4 mt-3">
                                <h5>Lead Status</h5>
                                <div class="d-flex align-items-center mt-3">
                                    @php
                                        $statuses = [
                                            1 => ['name' => 'New', 'color' => 'success'],
                                            2 => ['name' => 'RO Assigned', 'color' => 'success'],
                                            3 => ['name' => 'RO Verified', 'color' => 'success'],
                                            4 => ['name' => 'Branch Review', 'color' => 'success'],
                                             5 => ['name' => 'Branch Approved', 'color' => 'success'],
                                            6 => ['name' => 'Bank wise approve', 'color' => 'success'],
                                            7 => ['name' => 'Final Lead source', 'color' => 'success'],
                                            90 => ['name' => 'Cancelled', 'color' => 'danger'],
                                            91 => ['name' => 'Other', 'color' => 'dark'],
                                        ];
                                        $currentStatus = $applicant->status;
                                    @endphp

                                    <div class="lead-tracker">
                                        @foreach ($statuses as $statusId => $status)
                                            @if ($statusId <= 6)
                                                @php
                                                    $class = 'step-disabled';
                                                    if ($statusId < $currentStatus) {
                                                        $class = 'step-done';
                                                    } elseif ($statusId == $currentStatus) {
                                                        $class = 'step-active';
                                                    }
                                                    $log = $statusLogs->get($statusId);
                                                @endphp

                                                <div class="step {{ $class }}">
                                                    <div>
                                                        {{ $status['name'] }}
                                                        @if ($log)
                                                            <span class="info-icon" data-bs-toggle="tooltip"
                                                                data-bs-placement="top" data-bs-html="true"
                                                                title="{{ $log->actionBy->name ?? 'N/A' }} - {{ $log->action_date ? \Carbon\Carbon::parse($log->action_date)->format('d/m/Y h:i A') : 'N/A' }}  <br> REMARK -  {{ $log->remark ?? '' }}"
                                                                style="display: inline-block; width: 14px; height: 14px; background: rgba(255,255,255,0.3); border-radius: 50%; text-align: center; line-height: 14px; font-size: 10px; margin-left: 5px; cursor: pointer;">i</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>

                                    @if ($currentStatus == 90)
                                        <i class="fas fa-arrow-down mx-2 text-danger"></i>
                                        <span class="badge bg-danger px-3 py-2">
                                            Cancelled
                                        </span>
                                    @endif

                                    @if ($currentStatus == 91)
                                        <i class="fas fa-arrow-down mx-2 text-dark"></i>
                                        <span class="badge bg-dark px-3 py-2">
                                            Other
                                        </span>
                                    @endif
                                </div>

                                <div class="mt-3 text-end">
                                    <a href="{{ route('lead.edit', $applicant->id) }}" class="btn btn-info">
                                        <i class="fas fa-edit"></i> Approve/Reject
                                    </a>

                                    <a href="{{ route('lead.edit', $applicant->id) }}" class="btn btn-primary">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>

                                    <a href="{{ route('lead.assign') }}" class="btn btn-secondary me-2">
                                        <i class="fas fa-arrow-left"></i> Back
                                    </a>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const images = document.querySelectorAll('.image-hover');
            let preview = null;

            images.forEach(img => {
                img.addEventListener('mouseenter', function(e) {
                    preview = document.createElement('img');
                    preview.src = this.src;
                    preview.className = 'img-preview';
                    preview.style.maxWidth = '400px';
                    preview.style.maxHeight = '400px';
                    document.body.appendChild(preview);

                    const rect = this.getBoundingClientRect();
                    preview.style.position = 'fixed';
                    preview.style.left = (rect.right + 10) + 'px';
                    preview.style.top = rect.top + 'px';
                    preview.style.display = 'block';
                });

                img.addEventListener('mouseleave', function() {
                    if (preview) {
                        preview.remove();
                        preview = null;
                    }
                });

                img.addEventListener('mousemove', function(e) {
                    if (preview) {
                        preview.style.left = (e.clientX + 10) + 'px';
                        preview.style.top = (e.clientY - 100) + 'px';
                    }
                });
            });
        });
    </script>

@endsection
