{{-- Example usage in any form --}}

{{-- Method 1: Using Helper Class --}}
@php
    use App\Helpers\DynamicDropdownHelper;
    $genderOptions = DynamicDropdownHelper::getOptions('gender');
@endphp

<div class="mb-3">
    <label for="gender" class="form-label">Gender</label>
    <select class="form-select" id="gender" name="gender">
        <option value="">Select Gender</option>
        @foreach($genderOptions as $option)
            <option value="{{ $option->option_value }}" {{ old('gender') == $option->option_value ? 'selected' : '' }}>
                {{ $option->option_label }}
            </option>
        @endforeach
    </select>
</div>

{{-- Method 2: Direct Model Query --}}
@php
    $maritalStatusField = \App\Models\FormField::where('field_key', 'marital_status')
        ->where('status', 1)
        ->with(['options' => function($query) {
            $query->where('status', 1)->orderBy('sort_order');
        }])
        ->first();
@endphp

@if($maritalStatusField)
<div class="mb-3">
    <label for="marital_status" class="form-label">{{ $maritalStatusField->field_label }}</label>
    
    @if($maritalStatusField->field_type == 'select')
        <select class="form-select" id="marital_status" name="marital_status">
            <option value="">Select {{ $maritalStatusField->field_label }}</option>
            @foreach($maritalStatusField->options as $option)
                <option value="{{ $option->option_value }}">{{ $option->option_label }}</option>
            @endforeach
        </select>
    @elseif($maritalStatusField->field_type == 'radio')
        @foreach($maritalStatusField->options as $option)
            <div class="form-check">
                <input class="form-check-input" type="radio" name="marital_status" 
                       id="marital_status_{{ $option->id }}" value="{{ $option->option_value }}">
                <label class="form-check-label" for="marital_status_{{ $option->id }}">
                    {{ $option->option_label }}
                </label>
            </div>
        @endforeach
    @elseif($maritalStatusField->field_type == 'checkbox')
        @foreach($maritalStatusField->options as $option)
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="marital_status[]" 
                       id="marital_status_{{ $option->id }}" value="{{ $option->option_value }}">
                <label class="form-check-label" for="marital_status_{{ $option->id }}">
                    {{ $option->option_label }}
                </label>
            </div>
        @endforeach
    @endif
</div>
@endif