@extends('layout.layout')
@section('content')
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}
.modern-form {
    background: white;
    border-radius: 16px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    border: none;
    overflow: hidden;
}
.form-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 24px;
}
.form-title {
    font-size: 24px;
    font-weight: 700;
    margin: 0;
}
.form-subtitle {
    opacity: 0.9;
    margin: 4px 0 0 0;
    font-size: 14px;
}
.form-body {
    padding: 32px;
}
.form-group {
    margin-bottom: 24px;
}
.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 8px;
    font-size: 14px;
}
.form-control, .form-select {
    border: 2px solid #e5e7eb;
    border-radius: 12px;
    padding: 12px 16px;
    font-size: 14px;
    transition: all 0.3s ease;
    /* background: #fafafa; */
}
.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    background: white;
}
.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
    padding: 12px 32px;
    border-radius: 12px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}
.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
}
.btn-secondary {
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    color: #64748b;
    padding: 10px 24px;
    border-radius: 12px;
    font-weight: 500;
    transition: all 0.3s ease;
}
.btn-secondary:hover {
    background: #e2e8f0;
    border-color: #cbd5e1;
    color: #475569;
}
.header-section {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    border-radius: 16px;
    padding: 24px;
    margin-bottom: 24px;
    border: 1px solid #e2e8f0;
}
.page-title {
    font-size: 28px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}
.page-subtitle {
    color: #64748b;
    font-size: 16px;
    margin: 4px 0 0 0;
}
.field-icon {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
    color: white;
    margin-right: 12px;
}
.invalid-feedback {
    font-size: 12px;
    font-weight: 500;
}
.form-control.is-invalid, .form-select.is-invalid {
    border-color: #ef4444;
    background: #fef2f2;
}
</style>

<div class="page-content">
    <div class="container-fluid">
        <div class="header-section">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="page-title">Create Form Field</h1>
                    <p class="page-subtitle">Add a new dynamic form field to your collection</p>
                </div>
                <a href="{{ route('form-fields.index') }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to List
                </a>
            </div>
        </div>

        <div class="modern-form">
            <div class="form-header">
                <div class="d-flex align-items-center">
                    <div class="field-icon" style="background: rgba(255,255,255,0.2);">
                        <i class="ri-add-fill"></i>
                    </div>
                    <div>
                        <h3 class="form-title text-white">Field Configuration</h3>
                        <p class="form-subtitle">Configure your new form field settings</p>
                    </div>
                </div>
            </div>
            
            <div class="form-body">
                <form method="POST" action="{{ route('form-fields.store') }}">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="field_name" class="form-label">
                                    <i class="fas fa-code me-2 text-primary"></i>Field Name
                                </label>
                                <input type="text" class="form-control @error('field_name') is-invalid @enderror" 
                                       id="field_name" name="field_name" value="{{ old('field_name') }}" 
                                       placeholder="e.g., user_category" required>
                                @error('field_name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="field_label" class="form-label">
                                    <i class="fas fa-tag me-2 text-success"></i>Field Label
                                </label>
                                <input type="text" class="form-control @error('field_label') is-invalid @enderror" 
                                       id="field_label" name="field_label" value="{{ old('field_label') }}" 
                                       placeholder="e.g., User Category" required>
                                @error('field_label')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="field_type" class="form-label">
                                    <i class="fas fa-list me-2 text-info"></i>Field Type
                                </label>
                                <select class="form-select @error('field_type') is-invalid @enderror" 
                                        id="field_type" name="field_type" required>
                                    <option value="">Choose field type...</option>
                                    <option value="select" {{ old('field_type') == 'select' ? 'selected' : '' }}>📋 Select Dropdown</option>
                                    <option value="radio" {{ old('field_type') == 'radio' ? 'selected' : '' }}>🔘 Radio Button</option>
                                    <option value="checkbox" {{ old('field_type') == 'checkbox' ? 'selected' : '' }}>☑️ Checkbox</option>
                                </select>
                                @error('field_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="master_type" class="form-label">
                                    <i class="fas fa-sitemap me-2 text-warning"></i>Master Type
                                </label>
                                <select class="form-select @error('master_type') is-invalid @enderror" 
                                        id="master_type" name="master_type" onchange="toggleMasterOptions()">
                                    <option value="">Choose master type...</option>
                                    <option value="master" {{ old('master_type') == 'master' ? 'selected' : '' }}>🏆 Master Field</option>
                                    <option value="sub_master" {{ old('master_type') == 'sub_master' ? 'selected' : '' }}>🔗 Sub Master Field</option>
                                </select>
                                @error('master_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6" id="master_field_div" style="display: none;">
                            <div class="form-group">
                                <label for="parent_field_id" class="form-label">
                                    <i class="fas fa-link me-2 text-purple"></i>Parent Master Field
                                </label>
                                <select class="form-select @error('parent_field_id') is-invalid @enderror" 
                                        id="parent_field_id" name="parent_field_id">
                                    <option value="">Select parent field...</option>
                                    @php
                                        try {
                                            $masterFields = \App\Models\FormField::where('status', 1)->get();
                                        } catch (\Exception $e) {
                                            $masterFields = collect();
                                        }
                                    @endphp
                                    @foreach($masterFields as $masterField)
                                        <option value="{{ $masterField->id }}" {{ old('parent_field_id') == $masterField->id ? 'selected' : '' }}>
                                            {{ $masterField->field_label }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('parent_field_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status" class="form-label">
                                    <i class="fas fa-toggle-on me-2 text-success"></i>Status
                                </label>
                                <select class="form-select @error('status') is-invalid @enderror" name="status" required>
                                    <option value="1" {{ old('status', 1) == 1 ? 'selected' : '' }}>✅ Active</option>
                                    <option value="0" {{ old('status') == 0 ? 'selected' : '' }}>❌ Inactive</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-end gap-3 mt-4 pt-4 border-top">
                        <a href="{{ route('form-fields.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Create Field
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function toggleMasterOptions() {
    const masterType = document.getElementById('master_type').value;
    const masterDiv = document.getElementById('master_field_div');
    const parentFieldSelect = document.getElementById('parent_field_id');
    
    if (masterType === 'sub_master') {
        masterDiv.style.display = 'block';
        parentFieldSelect.required = true;
    } else {
        masterDiv.style.display = 'none';
        parentFieldSelect.required = false;
        parentFieldSelect.value = '';
    }
}

document.addEventListener('DOMContentLoaded', function() {
    toggleMasterOptions();
});
</script>
@endsection