@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">All Submenus</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Menu Masters</a></li>
                                <li class="breadcrumb-item active">All Submenus</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Submenu Management</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Menu / Submenu Name</th>
                                        <th>Parent</th>
                                        <th>Priority</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($menus as $menu)
                                    <tr class="table-info">
                                        <td><strong>{{ $menu->name }}</strong></td>
                                        <td>-</td>
                                        <td><strong>{{ $menu->priority }}</strong></td>
                                        <td>
                                            <span class="badge {{ $menu->status ? 'bg-success' : 'bg-danger' }}">
                                                {{ $menu->status ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('submenu.index', $menu->id) }}" class="btn btn-sm btn-primary">
                                                Manage Submenus
                                            </a>
                                        </td>
                                    </tr>
                                    @foreach($subMenus->where('menu_id', $menu->id)->where('parent_id', null)->sortBy('priority') as $parentSubmenu)
                                    <tr class="table-light">
                                        <td class="ps-4">└─ {{ $parentSubmenu->name }}</td>
                                        <td>-</td>
                                        <td>{{ $parentSubmenu->priority }}</td>
                                        <td>
                                            <span class="badge {{ $parentSubmenu->status ? 'bg-success' : 'bg-danger' }}">
                                                {{ $parentSubmenu->status ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('submenu.index', $menu->id) }}" class="btn btn-sm btn-primary">
                                                Manage
                                            </a>
                                        </td>
                                    </tr>
                                    @foreach($subMenus->where('parent_id', $parentSubmenu->id)->sortBy('priority') as $childSubmenu)
                                    <tr>
                                        <td class="ps-5">└─ {{ $childSubmenu->name }}</td>
                                        <td>{{ $parentSubmenu->name }}</td>
                                        <td>{{ $childSubmenu->priority }}</td>
                                        <td>
                                            <span class="badge {{ $childSubmenu->status ? 'bg-success' : 'bg-danger' }}">
                                                {{ $childSubmenu->status ? 'Active' : 'Inactive' }}
                                            </span>
                                        </td>
                                        <td>
                                            <a href="{{ route('submenu.index', $menu->id) }}" class="btn btn-sm btn-primary">
                                                Manage
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                    @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        </div>
        <!-- container-fluid -->
    </div>
@endsection