@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Role-based Permission Management</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Role Masters</a></li>
                                <li class="breadcrumb-item active">Permissions</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Role-based Permission Management</h4>
                        </div>


                        <div class="card-body">
                            <form method="POST" action="{{ route('permissions.store') }}" id="permissionsForm">
                                @csrf
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <h5 class="form-label">Select Role</h5>
                                            <select name="role_id" id="role_id" class="form-control" required>
                                                <option value="">Choose Role</option>
                                                @foreach ($roles as $role)
                                                    <option value="{{ $role->id }}" {{ old('role_id') == $role->id ? 'selected' : '' }}>{{ $role->name }}</option>
                                                @endforeach
                                            </select>
                                            @error('role_id')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h5>Menu Permissions</h5>
                                        <div class="border p-3 mb-3" style="max-height: 300px; overflow-y: auto;">
                                            @foreach ($menus as $menu)
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input menu-checkbox" type="checkbox"
                                                        name="menu_permissions[]" value="{{ $menu->id }}"
                                                        id="menu_{{ $menu->id }}" data-menu-id="{{ $menu->id }}">
                                                    <label class="form-check-label fw-bold" for="menu_{{ $menu->id }}">
                                                        {{ $menu->name }}
                                                    </label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h5>SubMenu Permissions</h5>
                                        <div class="border p-3 mb-3" style="max-height: 300px; overflow-y: auto;"
                                            id="submenu-container">
                                            <p class="text-muted">Select a menu to view its submenus</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="text-end">
                                    <button type="button" class="btn btn-danger me-2" id="resetPermissions">Reset
                                        Permissions</button>
                                    <button type="submit" class="btn btn-primary">Save Permissions</button>
                                </div>
                            </form>
                        </div>


                        <!-- Current Permissions Display -->
                        <div class="card-body border-bottom">
                            <h5 class="mb-3">Current Role Permissions</h5>
                            <div class="row">
                                @foreach ($roles as $role)
                                    <div class="col-md-6 mb-3">
                                        <div class="border rounded p-3">
                                            <h6 class="text-primary mb-2">{{ $role->name }}</h6>
                                            @if (isset($rolePermissions[$role->id]) && $rolePermissions[$role->id]->count() > 0)
                                                @foreach ($rolePermissions[$role->id] as $permission)
                                                    <div class="mb-3">
                                                        <div class="d-flex align-items-center mb-2">
                                                            <i class="ri-folder-line text-warning me-2"></i>
                                                            <strong>{{ $permission->menu->name ?? 'N/A' }}</strong>
                                                        </div>
                                                        @if ($permission->submenu_data)
                                                            <div class="ms-4">
                                                                @foreach ($permission->submenu_data['parent'] as $submenu)
                                                                    <div class="mb-2">
                                                                        <div class="d-flex align-items-center">
                                                                            <i class="ri-file-line text-info me-2"></i>
                                                                            <small
                                                                                class="text-dark">{{ $submenu->name }}</small>
                                                                        </div>
                                                                        @if (isset($permission->submenu_data['child'][$submenu->id]))
                                                                            <div class="ms-4">
                                                                                @foreach ($permission->submenu_data['child'][$submenu->id] as $childSubmenu)
                                                                                    <div
                                                                                        class="d-flex align-items-center mb-1">
                                                                                        <i
                                                                                            class="ri-arrow-right-s-line text-muted me-1"></i>
                                                                                        <small
                                                                                            class="text-muted">{{ $childSubmenu->name }}</small>
                                                                                    </div>
                                                                                @endforeach
                                                                            </div>
                                                                        @endif
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            @else
                                                <small class="text-muted">No permissions assigned</small>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>

        <script src="{{ asset('assets/js/pages/permissions.js') }}"></script>

    </div>
    <!-- container-fluid -->
    </div>
@endsection
