@extends('layout.layout')
@section('content')
    <div class="page-content">
        <div class="container-fluid">
            <div class="position-relative mx-n4 mt-n4">
                <div class="profile-wid-bg profile-setting-img">
                    <img src="{{ asset('assets/images/profile-bg.jpg') }}" class="profile-wid-img" alt="">
                </div>
            </div>

            <div class="row">
                <div class="col-xxl-3">
                    <div class="card mt-n5">
                        <div class="card-body p-4">
                            <div class="text-center">
                                <div class="profile-user position-relative d-inline-block mx-auto  mb-4">
                                    <img src="{{ asset('assets/images/users/avatar-1.jpg') }}"
                                        class="rounded-circle avatar-xl img-thumbnail user-profile-image material-shadow"
                                        alt="user-profile-image">
                                </div>
                                <h5 class="fs-16 mb-1">{{ $user->name }}</h5>
                                <p class="text-muted mb-0">{{ $user->email }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-9">
                    <div class="card mt-xxl-n5">
                        <div class="card-header">
                            <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#personalDetails" role="tab"
                                        aria-selected="true">
                                        <i class="fas fa-home"></i> Personal Details
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" data-bs-toggle="tab" href="#changePassword" role="tab"
                                        aria-selected="false" tabindex="-1">
                                        <i class="far fa-user"></i> Change Password
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body p-4">
                            @if (session('success'))
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    {{ session('success') }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            @endif
                            @if (session('error'))
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    {{ session('error') }}
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                </div>
                            @endif
                            <div class="tab-content">
                                <div class="tab-pane active" id="personalDetails" role="tabpanel">
                                    <form method="POST" action="{{ route('profile.update') }}">
                                        @csrf
                                        <input type="hidden" id="user_id" value="{{ $user->id }}">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="name" class="form-label">Name</label>
                                                    <input type="text"
                                                        class="form-control @error('name') is-invalid @enderror"
                                                        id="name" name="name" value="{{ old('name', $user->name) }}"
                                                        placeholder="Enter full name" required>
                                                    @error('name')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="father_name" class="form-label">Father Name</label>
                                                    <input type="text" class="form-control" id="father_name"
                                                        name="father_name"
                                                        value="{{ old('father_name', $user->father_name) }}"
                                                        placeholder="Enter father name">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="mother_name" class="form-label">Mother Name</label>
                                                    <input type="text" class="form-control" id="mother_name"
                                                        name="mother_name"
                                                        value="{{ old('mother_name', $user->mother_name) }}"
                                                        placeholder="Enter mother name">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="dob" class="form-label">Date of Birth </label>
                                                    <input type="date" class="form-control" id="dob" name="dob"
                                                        value="{{ old('dob', optional($user->dob)->format('Y-m-d')) }}">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="gender" class="form-label">Gender</label>
                                                    <select class="form-select" id="gender" name="gender">
                                                        <option value="">Select Gender</option>
                                                        <option value="male"
                                                            {{ old('gender', $user->gender) == 'male' ? 'selected' : '' }}>
                                                            Male</option>
                                                        <option value="female"
                                                            {{ old('gender', $user->gender) == 'female' ? 'selected' : '' }}>
                                                            Female</option>
                                                        <option value="other"
                                                            {{ old('gender', $user->gender) == 'other' ? 'selected' : '' }}>
                                                            Other</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="marital_status" class="form-label">Marital Status</label>
                                                    <select class="form-select" id="marital_status"
                                                        name="marital_status">
                                                        <option value="">Select Marital Status</option>
                                                        <option value="single"
                                                            {{ old('marital_status', $user->marital_status) == 'single' ? 'selected' : '' }}>
                                                            Single</option>
                                                        <option value="married"
                                                            {{ old('marital_status', $user->marital_status) == 'married' ? 'selected' : '' }}>
                                                            Married</option>
                                                        <option value="divorced"
                                                            {{ old('marital_status', $user->marital_status) == 'divorced' ? 'selected' : '' }}>
                                                            Divorced</option>
                                                        <option value="widowed"
                                                            {{ old('marital_status', $user->marital_status) == 'widowed' ? 'selected' : '' }}>
                                                            Widowed</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="email" class="form-label">Email</label>
                                                    <input type="email" class="form-control" id="email"
                                                        name="email" value="{{ old('email', $user->email) }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="mobile" class="form-label">Mobile</label>
                                                    <input type="text" class="form-control" id="mobile"
                                                        name="mobile" value="{{ old('mobile', $user->mobile) }}"
                                                        readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="alternate_mobile" class="form-label">Alternate
                                                        Mobile</label>
                                                    <input type="text" class="form-control" id="alternate_mobile"
                                                        name="alternate_mobile"
                                                        value="{{ old('alternate_mobile', $user->alternate_mobile) }}"
                                                        readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="aadhaar_number" class="form-label">Aadhaar Number</label>
                                                    <input type="text" class="form-control" id="aadhaar_number"
                                                        name="aadhaar_number"
                                                        value="{{ old('aadhaar_number', $user->aadhaar_number) }}"
                                                        readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="pan_number" class="form-label">PAN Number</label>
                                                    <input type="text" class="form-control" id="pan_number"
                                                        name="pan_number"
                                                        value="{{ old('pan_number', $user->pan_number) }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="joining_date" class="form-label">Joining Date</label>
                                                    <input type="text" class="form-control" id="joining_date"
                                                        name="joining_date"
                                                        value="{{ $user->joining_date ? $user->joining_date->format('d-m-Y') : 'N/A' }}"
                                                        readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="role" class="form-label">Role</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ $user->role->name ?? 'N/A' }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="department" class="form-label">Department</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ $user->department->name ?? 'N/A' }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="branch" class="form-label">Branch</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ $user->branch->branch_name ?? 'N/A' }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="state_id" class="form-label">State</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ $user->state->name ?? 'N/A' }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="district_id" class="form-label">District</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ $user->district->name ?? 'N/A' }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="city_id" class="form-label">City</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ $user->city->name ?? 'N/A' }}" readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label for="pincode" class="form-label">Pincode</label>
                                                    <input type="text" class="form-control" id="pincode"
                                                        name="pincode" value="{{ old('pincode', $user->pincode) }}"
                                                        readonly>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="mb-3">
                                                    <label for="address" class="form-label">Address</label>
                                                    <textarea class="form-control" id="address" name="address" rows="3" readonly>{{ old('address', $user->address) }}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Profile Picture</label>
                                                    @if ($user->profile_pic)
                                                        <div><a href="{{ route('document.view', ['type' => 'profile', 'filename' => basename($user->profile_pic)]) }}"
                                                                target="_blank"
                                                                class="btn btn-sm btn-outline-primary">View Document</a>
                                                        </div>
                                                    @else
                                                        <div class="text-muted">No document uploaded</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhaar Front</label>
                                                    @if ($user->addhar_front_pic)
                                                        <div><a href="{{ route('document.view', ['type' => 'document', 'filename' => basename($user->addhar_front_pic)]) }}"
                                                                target="_blank"
                                                                class="btn btn-sm btn-outline-primary">View Document</a>
                                                        </div>
                                                    @else
                                                        <div class="text-muted">No document uploaded</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Aadhaar Back</label>
                                                    @if ($user->addhar_back_pic)
                                                        <div><a href="{{ route('document.view', ['type' => 'document', 'filename' => basename($user->addhar_back_pic)]) }}"
                                                                target="_blank"
                                                                class="btn btn-sm btn-outline-primary">View Document</a>
                                                        </div>
                                                    @else
                                                        <div class="text-muted">No document uploaded</div>
                                                    @endif
                                                </div>
                                            </div>

                                        </div>
                                    </form>
                                </div>

                                <div class="tab-pane" id="changePassword" role="tabpanel">
                                    @if (session('success'))
                                        <div class="alert alert-success">{{ session('success') }}</div>
                                    @endif
                                    <form method="POST" action="{{ route('profile.change-password') }}">
                                        @csrf
                                        <div class="row g-2">
                                            <div class="col-lg-4">
                                                <div>
                                                    <label for="current_password" class="form-label">Old Password*</label>
                                                    <input type="password"
                                                        class="form-control @error('current_password') is-invalid @enderror"
                                                        name="current_password" id="current_password"
                                                        placeholder="Enter current password" required>
                                                    @error('current_password')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div>
                                                    <label for="new_password" class="form-label">New Password*</label>
                                                    <input type="password"
                                                        class="form-control @error('new_password') is-invalid @enderror"
                                                        name="new_password" id="new_password"
                                                        placeholder="Enter new password" required>
                                                    <small class="text-muted">Min 8 chars, 1 uppercase, 1 lowercase, 1
                                                        number, 1 special char</small>
                                                    @error('new_password')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-4">
                                                <div>
                                                    <label for="new_password_confirmation" class="form-label">Confirm
                                                        Password*</label>
                                                    <input type="password" class="form-control" name="confirm_password"
                                                        id="confirm_password" placeholder="Confirm password" required>
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="text-end">
                                                    <button type="submit" class="btn btn-success">Change
                                                        Password</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- container-fluid -->
    </div>
    <!-- End Page-content -->

    <script>
        // Load districts based on state selection
        document.getElementById('state_id').addEventListener('change', function() {
            const stateId = this.value;
            const districtSelect = document.getElementById('district_id');
            const citySelect = document.getElementById('city_id');

            districtSelect.innerHTML = '<option value="">Select District</option>';
            citySelect.innerHTML = '<option value="">Select City</option>';

            if (stateId) {
                fetch(`/api/districts/${stateId}`)
                    .then(response => response.json())
                    .then(data => {
                        data.data.forEach(district => {
                            districtSelect.innerHTML +=
                                `<option value="${district.id}">${district.name}</option>`;
                        });
                    });
            }
        });

        // Load cities based on district selection
        document.getElementById('district_id').addEventListener('change', function() {
            const districtId = this.value;
            const citySelect = document.getElementById('city_id');

            citySelect.innerHTML = '<option value="">Select City</option>';

            if (districtId) {
                fetch(`/api/cities/${districtId}`)
                    .then(response => response.json())
                    .then(data => {
                        data.data.forEach(city => {
                            citySelect.innerHTML += `<option value="${city.id}">${city.name}</option>`;
                        });
                    });
            }
        });

        // Load districts on page load if state is selected
        window.addEventListener('load', function() {
            const stateId = document.getElementById('state_id').value;
            const userDistrictId = '{{ $user->district_id }}';
            const userCityId = '{{ $user->city_id }}';

            if (stateId) {
                fetch(`/api/districts/${stateId}`)
                    .then(response => response.json())
                    .then(data => {
                        const districtSelect = document.getElementById('district_id');
                        districtSelect.innerHTML = '<option value="">Select District</option>';
                        data.data.forEach(district => {
                            const selected = district.id == userDistrictId ? 'selected' : '';
                            districtSelect.innerHTML +=
                                `<option value="${district.id}" ${selected}>${district.name}</option>`;
                        });

                        // Load cities if district is selected
                        if (userDistrictId) {
                            fetch(`/api/cities/${userDistrictId}`)
                                .then(response => response.json())
                                .then(data => {
                                    const citySelect = document.getElementById('city_id');
                                    citySelect.innerHTML = '<option value="">Select City</option>';
                                    data.data.forEach(city => {
                                        const selected = city.id == userCityId ? 'selected' : '';
                                        citySelect.innerHTML +=
                                            `<option value="${city.id}" ${selected}>${city.name}</option>`;
                                    });
                                });
                        }
                    });
            }
        });
    </script>
@endsection
