<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\LocationController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\SettingsController;
use App\Http\Controllers\Api\MasterController;
use App\Http\Controllers\Api\RoController;
use App\Http\Controllers\Api\RoLeadController;

// Recovery Officer API Routes
Route::prefix('roapp')->group(function () {
    Route::post('/login', [AuthController::class, 'login']);

    Route::middleware(['reject.query.string', 'auth:sanctum', 'check.user.status'])->group(function () {
        Route::post('/logout', [AuthController::class, 'logout']);
        Route::post('/user', [AuthController::class, 'user']);

        // Settings Routes
        Route::post('/settings/toggle-logging', [SettingsController::class, 'toggleApiLogging']);
        Route::post('/settings/logging-status', [SettingsController::class, 'getApiLoggingStatus']);


        // Master APIs
        Route::post('/master-users', [MasterController::class, 'masterUsers']);
        Route::post('/form-master-fields', [MasterController::class, 'formMasterFields']);

        // RO APIs
        Route::post('/ro-assigned-leads', [RoController::class, 'roAssignedLeads']);

        // RO Lead APIs
        Route::post('/ro-create-new-lead', [RoLeadController::class, 'store']);
        Route::post('/ro-edit-lead', [RoLeadController::class, 'edit']);
        Route::post('/ro-update-lead', [RoLeadController::class, 'update']);
    });
});



// State APIs
Route::get('/states', [LocationController::class, 'getStates']);
Route::get('/state/{id}', [LocationController::class, 'getState']);
Route::post('/states', [LocationController::class, 'addState']);
Route::post('/states/update/{id}', [LocationController::class, 'updateState']);

// City APIs
// Route::get('/cities/{districtId?}', [LocationController::class, 'getCities']);
Route::get('/cities/{stateId}', [LocationController::class, 'getCities']);

Route::get('/city/{id}', [LocationController::class, 'getCity']);
Route::post('/cities', [LocationController::class, 'addCity']);
Route::post('/cities/update/{id}', [LocationController::class, 'updateCity']);
