<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Role-based Permission Management</h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Role Masters</a></li>
                                <li class="breadcrumb-item active">Permissions</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Role-based Permission Management</h4>
                        </div>


                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('permissions.store')); ?>" id="permissionsForm">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <h5 class="form-label">Select Role</h5>
                                            <select name="role_id" id="role_id" class="form-control" required>
                                                <option value="">Choose Role</option>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($role->id); ?>" <?php echo e(old('role_id') == $role->id ? 'selected' : ''); ?>><?php echo e($role->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php $__errorArgs = ['role_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="text-danger"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <h5>Menu Permissions</h5>
                                        <div class="border p-3 mb-3" style="max-height: 300px; overflow-y: auto;">
                                            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input menu-checkbox" type="checkbox"
                                                        name="menu_permissions[]" value="<?php echo e($menu->id); ?>"
                                                        id="menu_<?php echo e($menu->id); ?>" data-menu-id="<?php echo e($menu->id); ?>">
                                                    <label class="form-check-label fw-bold" for="menu_<?php echo e($menu->id); ?>">
                                                        <?php echo e($menu->name); ?>

                                                    </label>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <h5>SubMenu Permissions</h5>
                                        <div class="border p-3 mb-3" style="max-height: 300px; overflow-y: auto;"
                                            id="submenu-container">
                                            <p class="text-muted">Select a menu to view its submenus</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="text-end">
                                    <button type="button" class="btn btn-danger me-2" id="resetPermissions">Reset
                                        Permissions</button>
                                    <button type="submit" class="btn btn-primary">Save Permissions</button>
                                </div>
                            </form>
                        </div>


                        <!-- Current Permissions Display -->
                        <div class="card-body border-bottom">
                            <h5 class="mb-3">Current Role Permissions</h5>
                            <div class="row">
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 mb-3">
                                        <div class="border rounded p-3">
                                            <h6 class="text-primary mb-2"><?php echo e($role->name); ?></h6>
                                            <?php if(isset($rolePermissions[$role->id]) && $rolePermissions[$role->id]->count() > 0): ?>
                                                <?php $__currentLoopData = $rolePermissions[$role->id]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="mb-3">
                                                        <div class="d-flex align-items-center mb-2">
                                                            <i class="ri-folder-line text-warning me-2"></i>
                                                            <strong><?php echo e($permission->menu->name ?? 'N/A'); ?></strong>
                                                        </div>
                                                        <?php if($permission->submenu_data): ?>
                                                            <div class="ms-4">
                                                                <?php $__currentLoopData = $permission->submenu_data['parent']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <div class="mb-2">
                                                                        <div class="d-flex align-items-center">
                                                                            <i class="ri-file-line text-info me-2"></i>
                                                                            <small
                                                                                class="text-dark"><?php echo e($submenu->name); ?></small>
                                                                        </div>
                                                                        <?php if(isset($permission->submenu_data['child'][$submenu->id])): ?>
                                                                            <div class="ms-4">
                                                                                <?php $__currentLoopData = $permission->submenu_data['child'][$submenu->id]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childSubmenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <div
                                                                                        class="d-flex align-items-center mb-1">
                                                                                        <i
                                                                                            class="ri-arrow-right-s-line text-muted me-1"></i>
                                                                                        <small
                                                                                            class="text-muted"><?php echo e($childSubmenu->name); ?></small>
                                                                                    </div>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </div>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <small class="text-muted">No permissions assigned</small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>

        <script src="<?php echo e(asset('assets/js/pages/permissions.js')); ?>"></script>

    </div>
    <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\masters\user-role\permissions.blade.php ENDPATH**/ ?>