


<?php
    use App\Helpers\DynamicDropdownHelper;
    $genderOptions = DynamicDropdownHelper::getOptions('gender');
?>

<div class="mb-3">
    <label for="gender" class="form-label">Gender</label>
    <select class="form-select" id="gender" name="gender">
        <option value="">Select Gender</option>
        <?php $__currentLoopData = $genderOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($option->option_value); ?>" <?php echo e(old('gender') == $option->option_value ? 'selected' : ''); ?>>
                <?php echo e($option->option_label); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>


<?php
    $maritalStatusField = \App\Models\FormField::where('field_key', 'marital_status')
        ->where('status', 1)
        ->with(['options' => function($query) {
            $query->where('status', 1)->orderBy('sort_order');
        }])
        ->first();
?>

<?php if($maritalStatusField): ?>
<div class="mb-3">
    <label for="marital_status" class="form-label"><?php echo e($maritalStatusField->field_label); ?></label>
    
    <?php if($maritalStatusField->field_type == 'select'): ?>
        <select class="form-select" id="marital_status" name="marital_status">
            <option value="">Select <?php echo e($maritalStatusField->field_label); ?></option>
            <?php $__currentLoopData = $maritalStatusField->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($option->option_value); ?>"><?php echo e($option->option_label); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    <?php elseif($maritalStatusField->field_type == 'radio'): ?>
        <?php $__currentLoopData = $maritalStatusField->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="marital_status" 
                       id="marital_status_<?php echo e($option->id); ?>" value="<?php echo e($option->option_value); ?>">
                <label class="form-check-label" for="marital_status_<?php echo e($option->id); ?>">
                    <?php echo e($option->option_label); ?>

                </label>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php elseif($maritalStatusField->field_type == 'checkbox'): ?>
        <?php $__currentLoopData = $maritalStatusField->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="marital_status[]" 
                       id="marital_status_<?php echo e($option->id); ?>" value="<?php echo e($option->option_value); ?>">
                <label class="form-check-label" for="marital_status_<?php echo e($option->id); ?>">
                    <?php echo e($option->option_label); ?>

                </label>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
</div>
<?php endif; ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\admin\master\examples\dynamic-dropdown-usage.blade.php ENDPATH**/ ?>