<?php $__env->startSection('content'); ?>

    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">Assign Lead</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Lead Management</a></li>
                                <li class="breadcrumb-item active">Assign Lead</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <?php if(request()->hasAny(['status', 'branch_id', 'created_by', 'assign_to', 'start_date', 'end_date', 'search']) &&
                            (request()->filled('status') ||
                                request()->filled('branch_id') ||
                                request()->filled('created_by') ||
                                request()->filled('assign_to') ||
                                request()->filled('start_date') ||
                                request()->filled('end_date') ||
                                request()->filled('search'))): ?>
                        <div class="row">
                            <div class="col-xl-12 col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="d-flex">
                                            <div class="flex-grow-1">
                                                <h5 class="fs-16">Applied Filters</h5>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <a href="<?php echo e(route('lead.assign')); ?>" class="text-decoration-underline">CLEAR
                                                    ALL</a>
                                            </div>
                                        </div>
                                        <div class="filter-choices-input">
                                            <div class="choices" data-type="text">
                                                <div class="choices__inner">
                                                    <div class="choices__list choices__list--multiple" id="applied-filters">
                                                        <?php if(request('search')): ?>
                                                            <div class="choices__item choices__item--selectable">
                                                                Search: <?php echo e(request('search')); ?>

                                                                <button type="button" class="choices__button"
                                                                    onclick="removeFilter('search')">Remove</button>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if(request('status')): ?>
                                                            <?php $__currentLoopData = (array) request('status'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statusId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php
                                                                    $statusNames = [
                                                                        '1' => 'New',
                                                                        '2' => 'RO Assigned',
                                                                        '3' => 'RO Verified',
                                                                        '4' => 'Branch Review',
                                                                         '5' => 'Branch approved',
                                                                        '6' => 'Bank wise approve',
                                                                        '7' => 'Final Lead source',
                                                                        '90' => 'Cancelled',
                                                                        '91' => 'Other',
                                                                    ];
                                                                ?>
                                                                <div class="choices__item choices__item--selectable">
                                                                    Status: <?php echo e($statusNames[$statusId] ?? $statusId); ?>

                                                                    <button type="button" class="choices__button"
                                                                        onclick="removeArrayFilter('status', '<?php echo e($statusId); ?>')">Remove</button>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                        <?php if(request('branch_id')): ?>
                                                            <?php $__currentLoopData = (array) request('branch_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branchId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php $branch = $branches->find($branchId) ?>
                                                                <?php if($branch): ?>
                                                                    <div class="choices__item choices__item--selectable">
                                                                        Branch: <?php echo e($branch->branch_name); ?>

                                                                        <button type="button" class="choices__button"
                                                                            onclick="removeArrayFilter('branch_id', '<?php echo e($branchId); ?>')">Remove</button>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                        <?php if(request('created_by')): ?>
                                                            <?php $__currentLoopData = (array) request('created_by'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php $user = $users->find($userId) ?>
                                                                <?php if($user): ?>
                                                                    <div class="choices__item choices__item--selectable">
                                                                        Created By: <?php echo e($user->name); ?>

                                                                        <button type="button" class="choices__button"
                                                                            onclick="removeArrayFilter('created_by', '<?php echo e($userId); ?>')">Remove</button>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                        <?php if(request('assign_to')): ?>
                                                            <?php $__currentLoopData = (array) request('assign_to'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignId): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php $assignUser = $roUsers->find($assignId) ?>
                                                                <?php if($assignUser): ?>
                                                                    <div class="choices__item choices__item--selectable">
                                                                        Assigned To: <?php echo e($assignUser->name); ?>

                                                                        <button type="button" class="choices__button"
                                                                            onclick="removeArrayFilter('assign_to', '<?php echo e($assignId); ?>')">Remove</button>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                        <?php if(request('start_date') || request('end_date')): ?>
                                                            <div class="choices__item choices__item--selectable">
                                                                Date:
                                                                <?php echo e(request('start_date') ? request('start_date') : ''); ?><?php echo e(request('start_date') && request('end_date') ? ' to ' : ''); ?><?php echo e(request('end_date') ? request('end_date') : ''); ?>

                                                                <button type="button" class="choices__button"
                                                                    onclick="removeDateFilter()">Remove</button>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title mb-0">Lead List</h4>

                            <button type="button" class="btn btn-info" data-bs-toggle="offcanvas" href="#filterModal">
                                <i class="ri-filter-3-line align-bottom me-1"></i>
                                Filters
                            </button>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped table-nowrap align-middle mb-0" style="font-size: 12px;">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Applicant Name</th>
                                            <th scope="col">Contact Number</th>
                                            <th scope="col">Branch</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Created By</th>
                                            <th scope="col">Assigned To</th>
                                            <th scope="col">Created Date</th>
                                            <th scope="col">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $applicants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $applicant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?></td>
                                                <td><?php echo e($applicant->applicant_first_name); ?>

                                                    <?php echo e($applicant->applicant_last_name); ?></td>
                                                <td><?php echo e($applicant->contact_number); ?></td>
                                                <td><?php echo e($applicant->branch->branch_name ?? 'N/A'); ?></td>
                                                <td>
                                                    <?php switch($applicant->status):
                                                        case (1): ?>
                                                            <span class="badge bg-primary">New</span>
                                                        <?php break; ?>

                                                        <?php case (2): ?>
                                                            <span class="badge bg-info">RO Assigned</span>
                                                        <?php break; ?>

                                                        <?php case (3): ?>
                                                            <span class="badge bg-warning">RO Verified</span>
                                                        <?php break; ?>

                                                        <?php case (4): ?>
                                                            <span class="badge bg-secondary">Branch Review</span>
                                                        <?php break; ?>

                                                        <?php case (5): ?>
                                                            <span class="badge bg-secondary">Branch Approved</span>
                                                        <?php break; ?>

                                                        <?php case (6): ?>
                                                            <span class="badge bg-success">Bank wise approve</span>
                                                        <?php break; ?>

                                                        <?php case (7): ?>
                                                            <span class="badge bg-dark">Final Lead source</span>
                                                        <?php break; ?>

                                                        <?php case (90): ?>
                                                            <span class="badge bg-danger">Cancelled</span>
                                                        <?php break; ?>

                                                        <?php case (91): ?>
                                                            <span class="badge bg-light text-dark">Other</span>
                                                        <?php break; ?>

                                                        <?php default: ?>
                                                            <span class="badge bg-light text-dark">Unknown</span>
                                                    <?php endswitch; ?>
                                                </td>
                                                <td><?php echo e($applicant->creator->name ?? 'N/A'); ?></td>
                                                <td><?php echo e($applicant->assignedTo->name ?? 'Not Assigned'); ?></td>
                                                <td><?php echo e($applicant->created_at->format('d M Y h:i A')); ?></td>

                                                <td>
                                                    <button class="btn btn-sm btn-info"
                                                        onclick="viewLead(<?php echo e($applicant->id); ?>)">View</button>
                                                    <?php if(!$applicant->assign_to): ?>
                                                        <button class="btn btn-sm btn-success"
                                                            onclick="assignLead(<?php echo e($applicant->id); ?>)">Assign</button>
                                                    <?php endif; ?>
                                                    <form method="POST"
                                                        action="<?php echo e(route('lead.destroy', $applicant->id)); ?>"
                                                        style="display:inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Are you sure?')">Delete</button>
                                                    </form>
                                                    <button class="btn btn-sm btn-secondary"
                                                        onclick="toggleActions(<?php echo e($applicant->id); ?>)">⋯</button>
                                                    <div id="actions-<?php echo e($applicant->id); ?>" class="d-none mt-1">

                                                        <?php if($applicant->status == 3): ?>
                                                            <a href="<?php echo e(route('lead.branch-verify', $applicant->id)); ?>"
                                                                class="btn btn-sm btn-success me-1"
                                                                onclick="return confirm('Are you sure you want to start review this lead?')">Branch
                                                                Verify</a>
                                                        <?php endif; ?>

                                                        
                                                        
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="10" class="text-center">No leads found</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <?php echo e($applicants->links('pagination::bootstrap-4')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Assign Lead Modal -->
        <div class="modal fade" id="assignLeadModal" tabindex="-1" aria-labelledby="assignLeadModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="assignLeadModalLabel">Assign Applicant Lead</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="assignLeadForm">
                        <div class="modal-body">
                            <div id="assignAlert" class="alert" style="display: none;"></div>
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="applicant_id" name="applicant_id">
                            <div class="mb-3">
                                <label for="branch_select" class="form-label">Select Branch</label>
                                <select class="form-control" id="branch_select" name="branch_id" required>
                                    <option value="">Select Branch</option>
                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->branch_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="staff_select" class="form-label">Select RO Staff</label>
                                <select class="form-control" id="staff_select" name="assign_to" required>
                                    <option value="">Select Staff</option>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Assign Lead</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <!-- Filter Modal -->
        <div class="offcanvas offcanvas-end" tabindex="-1" id="filterModal" aria-labelledby="offcanvasExampleLabel"
            aria-modal="true" role="dialog">
            <div class="offcanvas-header bg-light">
                <h5 class="offcanvas-title" id="offcanvasExampleLabel">Expenses Fliters</h5>
                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
            </div>
            <!--end offcanvas-header-->
            <form action="<?php echo e(route('lead.assign')); ?>" method="GET" class="d-flex flex-column justify-content-end"
                style="height: 90%;">
                <div class="offcanvas-body">
                    <div class="mb-4">
                        <label for="date_from" class="form-label text-muted text-uppercase fw-semibold mb-3">Date
                            Range</label>
                        <div class="row g-2 align-items-center">
                            <div class="col-lg">
                                <input type="date" class="form-control" name="start_date" id="date_from"
                                    value="<?php echo e(request('start_date')); ?>" placeholder="From Date">
                            </div>
                            <div class="col-lg-auto">
                                To
                            </div>
                            <div class="col-lg">
                                <input type="date" class="form-control" name="end_date" id="date_to"
                                    value="<?php echo e(request('end_date')); ?>" placeholder="To Date">
                            </div>
                        </div>
                    </div>


                    <div class="mb-4">
                        <label for="date_from" class="form-label text-muted text-uppercase fw-semibold mb-3">Search by
                            applicant name OR number</label>
                        <div class="row g-2 align-items-center">
                            <div class="col-lg">
                                <input type="text" class="form-control" name="search" id="search"
                                    value="<?php echo e(request('search')); ?>" placeholder="Search by applicant name OR number">
                            </div>

                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Select
                            Lead Status</label>
                        <select class="js-example-basic-multiple" name="status[]" multiple="multiple"
                            data-placeholder="Select Status">
                            <option value="1" <?php echo e(in_array('1', (array) request('status', [])) ? 'selected' : ''); ?>>New
                            </option>
                            <option value="2" <?php echo e(in_array('2', (array) request('status', [])) ? 'selected' : ''); ?>>RO
                                Assigned</option>
                            <option value="3" <?php echo e(in_array('3', (array) request('status', [])) ? 'selected' : ''); ?>>RO
                                Verified</option>
                            <option value="4" <?php echo e(in_array('4', (array) request('status', [])) ? 'selected' : ''); ?>>Branch
                                Review</option>

                            <option value="5" <?php echo e(in_array('5', (array) request('status', [])) ? 'selected' : ''); ?>>Branch
                                Approved</option>

                            <option value="6" <?php echo e(in_array('6', (array) request('status', [])) ? 'selected' : ''); ?>>Bank
                                wise approve</option>
                            <option value="7" <?php echo e(in_array('7', (array) request('status', [])) ? 'selected' : ''); ?>>Final
                                Lead source</option>
                            <option value="90" <?php echo e(in_array('90', (array) request('status', [])) ? 'selected' : ''); ?>>
                                Cancelled</option>
                            <option value="91" <?php echo e(in_array('91', (array) request('status', [])) ? 'selected' : ''); ?>>Other
                            </option>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Select
                            Branch</label>
                        <select class="js-example-basic-multiple" name="branch_id[]" multiple="multiple"
                            data-placeholder="Select Branch">
                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($branch->id); ?>"
                                    <?php echo e(in_array($branch->id, (array) request('branch_id', [])) ? 'selected' : ''); ?>>
                                    <?php echo e($branch->branch_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Created
                            By</label>
                        <select class="js-example-basic-multiple" name="created_by[]" multiple="multiple"
                            data-placeholder="Select Created By">
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"
                                    <?php echo e(in_array($user->id, (array) request('created_by', [])) ? 'selected' : ''); ?>>
                                    <?php echo e($user->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="datepicker-range" class="form-label text-muted text-uppercase fw-semibold mb-3">Assign
                            to</label>
                        <select class="js-example-basic-multiple" name="assign_to[]" multiple="multiple"
                            data-placeholder="Select Assign To">
                            <?php $__currentLoopData = $roUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ro->id); ?>"
                                    <?php echo e(in_array($ro->id, (array) request('assign_to', [])) ? 'selected' : ''); ?>>
                                    <?php echo e($ro->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>


                </div>
                <!--end offcanvas-body-->
                <div class="offcanvas-footer border-top p-3 text-center hstack gap-2">
                    <button type="button" class="btn btn-light w-100" onclick="clearFilters()">Clear Filter</button>
                    <button type="submit" class="btn btn-success w-100">Apply Filters</button>
                </div>
                <!--end offcanvas-footer-->
            </form>
        </div>
        <!-- End Filter Modal -->






        <script src="<?php echo e(asset('assets/js/pages/lead-assign.js')); ?>"></script>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Filter removal functions
                window.removeFilter = function(filterName) {
                    const url = new URL(window.location);
                    url.searchParams.delete(filterName);
                    window.location.href = url.toString();
                };

                window.removeArrayFilter = function(filterName, value) {
                    const url = new URL(window.location);
                    const currentValues = url.searchParams.getAll(filterName + '[]');
                    url.searchParams.delete(filterName + '[]');

                    currentValues.forEach(val => {
                        if (val !== value) {
                            url.searchParams.append(filterName + '[]', val);
                        }
                    });

                    window.location.href = url.toString();
                };

                window.removeDateFilter = function() {
                    const url = new URL(window.location);
                    url.searchParams.delete('start_date');
                    url.searchParams.delete('end_date');
                    window.location.href = url.toString();
                };

                window.clearFilters = function() {
                    // Clear form fields only
                    document.getElementById('date_from').value = '';
                    document.getElementById('date_to').value = '';
                    document.getElementById('search').value = '';

                    // Clear all select2 dropdowns
                    $('.js-example-basic-multiple').val(null).trigger('change');
                };

                window.applyFilters = function() {
                    // Form will submit automatically
                };
            });
        </script>


    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\admin\leads\assign.blade.php ENDPATH**/ ?>