<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                        <h4 class="mb-sm-0">SubMenu Management - <?php echo e($menu->name); ?></h4>

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Masters</a></li>
                                <li class="breadcrumb-item"><a href="javascript: void(0);">Menu Masters</a></li>
                                <li class="breadcrumb-item active">SubMenu Management</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>
            <!-- end page title -->

            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="card-title mb-0">SubMenu Management - <?php echo e($menu->name); ?></h4>
                        <a href="<?php echo e(route('menu.index')); ?>" class="btn btn-sm btn-secondary mt-2">← Back to Menus</a>
                    </div>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addSubMenuModal">
                        Add SubMenu
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>SubMenu Name</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $subMenus->where('parent_id', null)->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parentSubmenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr style="background-color: rgba(53, 196, 77, 0.142);">
                                    <td><strong><?php echo e($parentSubmenu->id); ?></strong></td>
                                    <td><strong><?php echo e($parentSubmenu->name); ?></strong></td>
                                    <td><strong><?php echo e($parentSubmenu->priority); ?></strong></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($parentSubmenu->status ? 'success' : 'danger'); ?>">
                                            <?php echo e($parentSubmenu->status ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" onclick="editSubMenu(<?php echo e($parentSubmenu->id); ?>, '<?php echo e($parentSubmenu->name); ?>', <?php echo e($parentSubmenu->parent_id ?? 'null'); ?>, <?php echo e($parentSubmenu->priority); ?>, '<?php echo e($parentSubmenu->route); ?>')">Edit</button>
                                        <form method="POST" action="<?php echo e(route('submenu.toggle-status', [$menu->id, $parentSubmenu->id])); ?>" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                            <button type="submit" class="btn btn-sm btn-<?php echo e($parentSubmenu->status ? 'secondary' : 'success'); ?>">
                                                <?php echo e($parentSubmenu->status ? 'Deactivate' : 'Activate'); ?>

                                            </button>
                                        </form>
                                        <form method="POST" action="<?php echo e(route('submenu.destroy', [$menu->id, $parentSubmenu->id])); ?>" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                <?php $__currentLoopData = $subMenus->where('parent_id', $parentSubmenu->id)->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childSubmenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    
                                    <td class="ps-4">└─ <?php echo e($childSubmenu->name); ?></td>
                                    <td><?php echo e($childSubmenu->priority); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($childSubmenu->status ? 'success' : 'danger'); ?>">
                                            <?php echo e($childSubmenu->status ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" onclick="editSubMenu(<?php echo e($childSubmenu->id); ?>, '<?php echo e($childSubmenu->name); ?>', <?php echo e($childSubmenu->parent_id ?? 'null'); ?>, <?php echo e($childSubmenu->priority); ?>, '<?php echo e($childSubmenu->route); ?>')">Edit</button>
                                        <form method="POST" action="<?php echo e(route('submenu.toggle-status', [$menu->id, $childSubmenu->id])); ?>" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                                            <button type="submit" class="btn btn-sm btn-<?php echo e($childSubmenu->status ? 'secondary' : 'success'); ?>">
                                                <?php echo e($childSubmenu->status ? 'Deactivate' : 'Activate'); ?>

                                            </button>
                                        </form>
                                        <form method="POST" action="<?php echo e(route('submenu.destroy', [$menu->id, $childSubmenu->id])); ?>" class="d-inline">
                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add SubMenu Modal -->
<div class="modal fade" id="addSubMenuModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="<?php echo e(route('submenu.store', $menu->id)); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Add SubMenu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">SubMenu Name</label>
                        <input type="text" name="submenu_name" class="form-control" value="<?php echo e(old('submenu_name')); ?>" required>
                        <?php $__errorArgs = ['submenu_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Route</label>
                        <input type="text" name="route" class="form-control" placeholder="/masters/location/state" value="<?php echo e(old('route')); ?>">
                        <?php $__errorArgs = ['route'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Parent SubMenu</label>
                        <select name="parent_id" class="form-control">
                            <option value="">None (Main SubMenu)</option>
                            <?php $__currentLoopData = $subMenus->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parentMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($parentMenu->id); ?>" <?php echo e(old('parent_id') == $parentMenu->id ? 'selected' : ''); ?>><?php echo e($parentMenu->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['parent_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Priority</label>
                        <input type="number" name="priority" class="form-control" min="0" value="<?php echo e(old('priority')); ?>" required>
                        <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save SubMenu</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit SubMenu Modal -->
<div class="modal fade" id="editSubMenuModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" id="editSubMenuForm">
                <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Edit SubMenu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">SubMenu Name</label>
                        <input type="text" name="submenu_name" id="edit_submenu_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Route</label>
                        <input type="text" name="route" id="edit_route" class="form-control" placeholder="/masters/location/state">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Parent SubMenu</label>
                        <select name="parent_id" id="edit_parent_id" class="form-control">
                            <option value="">None (Main SubMenu)</option>
                            <?php $__currentLoopData = $subMenus->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parentMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($parentMenu->id); ?>"><?php echo e($parentMenu->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Priority</label>
                        <input type="number" name="priority" id="edit_submenu_priority" class="form-control" min="0" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update SubMenu</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editSubMenu(id, name, parentId, priority, route) {
    document.getElementById('edit_submenu_name').value = name;
    document.getElementById('edit_route').value = route || '';
    document.getElementById('edit_parent_id').value = parentId || '';
    document.getElementById('edit_submenu_priority').value = priority;
    document.getElementById('editSubMenuForm').action = '/masters/menu/<?php echo e($menu->id); ?>/submenu/' + id;
    new bootstrap.Modal(document.getElementById('editSubMenuModal')).show();
}
</script>

        </div>
        <!-- container-fluid -->
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\masters\menu\submenu.blade.php ENDPATH**/ ?>