<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                        <h4 class="mb-sm-0">Branch Management</h4>
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active">Branch Management</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>


            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Add New Branch</h4>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo e(route('branch.store')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="branch_name" class="form-label">Branch Name <span
                                                    class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control <?php $__errorArgs = ['branch_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="branch_name" name="branch_name" value="<?php echo e(old('branch_name')); ?>"
                                                required>
                                            <?php $__errorArgs = ['branch_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="branch_code" class="form-label">Branch Code <span
                                                    class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control <?php $__errorArgs = ['branch_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="branch_code" name="branch_code" value="<?php echo e(old('branch_code')); ?>"
                                                required>
                                            <?php $__errorArgs = ['branch_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="state_id" class="form-label">State <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-select <?php $__errorArgs = ['state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="state_id" name="state_id" required>
                                                <option value="">Select State</option>
                                                <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($state->id); ?>"
                                                        <?php echo e(old('state_id') == $state->id ? 'selected' : ''); ?>>
                                                        <?php echo e($state->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php $__errorArgs = ['state_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="district_id" class="form-label">District <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-select <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="district_id" name="district_id" required>
                                                <option value="">Select District</option>
                                            </select>
                                            <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="city_id" class="form-label">City <span
                                                    class="text-danger">*</span></label>
                                            <select class="form-select <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="city_id" name="city_id" required>
                                                <option value="">Select City</option>
                                            </select>
                                            <?php $__errorArgs = ['city_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label for="pincode" class="form-label">Pincode</label>
                                            <input type="text"
                                                class="form-control <?php $__errorArgs = ['pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="pincode"
                                                name="pincode" value="<?php echo e(old('pincode')); ?>" maxlength="6">
                                            <?php $__errorArgs = ['pincode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label for="address" class="form-label">Address</label>
                                            <textarea class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="address" name="address" rows="1"><?php echo e(old('address')); ?></textarea>
                                            <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-label">Head Branch</label>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="is_head_branch"
                                                    name="is_head_branch">
                                                <label class="form-check-label" for="is_head_branch">Yes</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-label">Active/Inactive Status</label>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id=""
                                                    name="status" checked>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12" style="text-align: right;">
                                        <div class="mb-3">
                                            <label class="form-label">&nbsp;</label>
                                            <div>
                                                <button type="submit" class="btn btn-primary">Add Branch</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Branches List</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Branch Name</th>
                                            <th>Branch Code</th>
                                            <th>Location</th>
                                            <th>Head Branch</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e($key+1); ?></td>
                                                <td><?php echo e($branch->branch_name); ?></td>
                                                <td><?php echo e($branch->branch_code); ?></td>
                                                <td><?php echo e($branch->city->name ?? ''); ?>, <?php echo e($branch->district->name ?? ''); ?>,
                                                    <?php echo e($branch->state->name ?? ''); ?></td>
                                                <td>
                                                    <span
                                                        class="badge bg-<?php echo e($branch->is_head_branch ? 'primary' : 'secondary'); ?>">
                                                        <?php echo e($branch->is_head_branch ? 'Yes' : 'No'); ?>

                                                    </span>
                                                </td>
                                                <td>
                                                    <span class="badge bg-<?php echo e($branch->status ? 'success' : 'danger'); ?>">
                                                        <?php echo e($branch->status ? 'Active' : 'Inactive'); ?>

                                                    </span>
                                                </td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-primary"
                                                        onclick="editBranch(<?php echo e($branch); ?>)">
                                                        Edit
                                                    </button>
                                                    <form action="<?php echo e(route('branch.toggle-status', $branch)); ?>"
                                                        method="POST" class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('PATCH'); ?>
                                                        <button type="submit"
                                                            class="btn btn-sm btn-<?php echo e($branch->status ? 'warning' : 'success'); ?>">
                                                            <?php echo e($branch->status ? 'Deactivate' : 'Activate'); ?>

                                                        </button>
                                                    </form>
                                                    <form action="<?php echo e(route('branch.destroy', $branch)); ?>" method="POST"
                                                        class="d-inline">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Are you sure you want to delete this branch?')">
                                                            Delete
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="7" class="text-center">No branches found</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

   

    <!-- Edit Branch Modal -->
    <div class="modal fade" id="editBranchModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form id="editBranchForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Branch</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="edit_branch_name" class="form-label">Branch Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="edit_branch_name" name="branch_name" required>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mb-3">
                                    <label for="edit_branch_code" class="form-label">Branch Code <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="edit_branch_code" name="branch_code" required>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_state_id" class="form-label">State <span class="text-danger">*</span></label>
                                    <select class="form-select" id="edit_state_id" name="state_id" required>
                                        <option value="">Select State</option>
                                        <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_district_id" class="form-label">District <span class="text-danger">*</span></label>
                                    <select class="form-select" id="edit_district_id" name="district_id" required>
                                        <option value="">Select District</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_city_id" class="form-label">City <span class="text-danger">*</span></label>
                                    <select class="form-select" id="edit_city_id" name="city_id" required>
                                        <option value="">Select City</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="edit_address" class="form-label">Address</label>
                                    <textarea class="form-control" id="edit_address" name="address" rows="2"></textarea>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label for="edit_pincode" class="form-label">Pincode</label>
                                    <input type="text" class="form-control" id="edit_pincode" name="pincode" maxlength="6">
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label class="form-label">Head Branch</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="edit_is_head_branch" name="is_head_branch">
                                        <label class="form-check-label" for="edit_is_head_branch">Yes</label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="mb-3">
                                    <label class="form-label">Active/Inactive Status</label>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="edit_status" name="status">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Update Branch</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

     <script>
        // State change handler
        document.getElementById('state_id').addEventListener('change', function() {
            const stateId = this.value;
            const districtSelect = document.getElementById('district_id');
            const citySelect = document.getElementById('city_id');

            districtSelect.innerHTML = '<option value="">Select District</option>';
            citySelect.innerHTML = '<option value="">Select City</option>';

            if (stateId) {
                fetch(`/api/districts/${stateId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            data.data.forEach(district => {
                                districtSelect.innerHTML +=
                                    `<option value="${district.id}">${district.name}</option>`;
                            });
                        }
                    });
            }
        });

        // District change handler
        document.getElementById('district_id').addEventListener('change', function() {
            const districtId = this.value;
            const citySelect = document.getElementById('city_id');

            citySelect.innerHTML = '<option value="">Select City</option>';

            if (districtId) {
                fetch(`/api/cities/${districtId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            data.data.forEach(city => {
                                citySelect.innerHTML +=
                                    `<option value="${city.id}">${city.name}</option>`;
                            });
                        }
                    });
            }
        });

        // Edit modal state change handler
        document.addEventListener('change', function(e) {
            if (e.target.id === 'edit_state_id') {
                const stateId = e.target.value;
                const districtSelect = document.getElementById('edit_district_id');
                const citySelect = document.getElementById('edit_city_id');

                districtSelect.innerHTML = '<option value="">Select District</option>';
                citySelect.innerHTML = '<option value="">Select City</option>';

                if (stateId) {
                    fetch(`/api/districts/${stateId}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                data.data.forEach(district => {
                                    districtSelect.innerHTML +=
                                        `<option value="${district.id}">${district.name}</option>`;
                                });
                            }
                        });
                }
            }
        });

        // Edit modal district change handler
        document.addEventListener('change', function(e) {
            if (e.target.id === 'edit_district_id') {
                const districtId = e.target.value;
                const citySelect = document.getElementById('edit_city_id');

                citySelect.innerHTML = '<option value="">Select City</option>';

                if (districtId) {
                    fetch(`/api/cities/${districtId}`)
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                data.data.forEach(city => {
                                    citySelect.innerHTML +=
                                        `<option value="${city.id}">${city.name}</option>`;
                                });
                            }
                        });
                }
            }
        });

        function editBranch(branch) {
            // Populate edit form fields
            document.getElementById('edit_branch_name').value = branch.branch_name;
            document.getElementById('edit_branch_code').value = branch.branch_code;
            document.getElementById('edit_state_id').value = branch.state_id;
            document.getElementById('edit_address').value = branch.address || '';
            document.getElementById('edit_pincode').value = branch.pincode || '';
            document.getElementById('edit_is_head_branch').checked = branch.is_head_branch;
            document.getElementById('edit_status').checked = branch.status;
            
            // Set form action
            document.getElementById('editBranchForm').action = `/masters/location/branch/${branch.id}`;
            
            // Load districts for selected state
            if (branch.state_id) {
                fetch(`/api/districts/${branch.state_id}`)
                    .then(response => response.json())
                    .then(data => {
                        const districtSelect = document.getElementById('edit_district_id');
                        districtSelect.innerHTML = '<option value="">Select District</option>';
                        if (data.success) {
                            data.data.forEach(district => {
                                const selected = district.id == branch.district_id ? 'selected' : '';
                                districtSelect.innerHTML += `<option value="${district.id}" ${selected}>${district.name}</option>`;
                            });
                        }
                        
                        // Load cities for selected district
                        if (branch.district_id) {
                            fetch(`/api/cities/${branch.district_id}`)
                                .then(response => response.json())
                                .then(data => {
                                    const citySelect = document.getElementById('edit_city_id');
                                    citySelect.innerHTML = '<option value="">Select City</option>';
                                    if (data.success) {
                                        data.data.forEach(city => {
                                            const selected = city.id == branch.city_id ? 'selected' : '';
                                            citySelect.innerHTML += `<option value="${city.id}" ${selected}>${city.name}</option>`;
                                        });
                                    }
                                });
                        }
                    });
            }
            
            // Show modal
            new bootstrap.Modal(document.getElementById('editBranchModal')).show();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\masters\location\branch.blade.php ENDPATH**/ ?>