<?php $__env->startSection('content'); ?>
<div class="page-content">
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Form Field Details</h5>
                    <div>
                        <a href="<?php echo e(route('form-fields.edit', $formField)); ?>" class="btn btn-warning btn-sm">Edit</a>
                        <a href="<?php echo e(route('form-fields.index')); ?>" class="btn btn-secondary btn-sm">Back</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="30%">Field Name:</th>
                                    <td><?php echo e($formField->field_key); ?></td>
                                </tr>
                                <tr>
                                    <th>Field Label:</th>
                                    <td><?php echo e($formField->field_label); ?></td>
                                </tr>
                                <tr>
                                    <th>Field Type:</th>
                                    <td><?php echo e(ucfirst($formField->field_type)); ?></td>
                                </tr>
                                <tr>
                                    <th>Status:</th>
                                    <td>
                                        <span class="badge badge-<?php echo e($formField->status ? 'success' : 'danger'); ?>">
                                            <?php echo e($formField->status ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <?php if($formField->options->count() > 0): ?>
                    <div class="mt-4">
                        <h6>Field Options</h6>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Label</th>
                                        <th>Value</th>
                                        <th>Sort Order</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $formField->options->sortBy('sort_order'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($option->option_label); ?></td>
                                        <td><?php echo e($option->option_value); ?></td>
                                        <td><?php echo e($option->sort_order); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo e($option->status ? 'success' : 'danger'); ?>">
                                                <?php echo e($option->status ? 'Active' : 'Inactive'); ?>

                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views\admin\master\form-fields\show.blade.php ENDPATH**/ ?>