<?php $__env->startSection('content'); ?>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}
.modern-table {
    background: white;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    border: none;
}
.modern-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}
.modern-table thead th {
    color: white;
    font-weight: 600;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    padding: 20px 16px;
    border: none;
}
.modern-table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #f1f5f9;
}
.modern-table tbody tr:hover {
    background: #f8fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.modern-table tbody td {
    padding: 16px;
    vertical-align: middle;
    border: none;
    font-size: 14px;
    color: #475569;
}
.field-name {
    font-weight: 600;
    color: #1e293b;
    font-size: 15px;
}
.field-label {
    color: #64748b;
    font-weight: 500;
}
.modern-badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.action-group {
    display: flex;
    gap: 6px;
    align-items: center;
}
.action-btn {
    padding: 8px 12px;
    border-radius: 8px;
    font-size: 12px;
    font-weight: 500;
    border: none;
    transition: all 0.2s ease;
    text-decoration: none;
}
.action-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}
.header-section {
    background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    border-radius: 16px;
    padding: 24px;
    margin-bottom: 24px;
    border: 1px solid #e2e8f0;
}
.page-title {
    font-size: 28px;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}
.page-subtitle {
    color: #64748b;
    font-size: 16px;
    margin: 4px 0 0 0;
}
.add-btn {
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: white;
    padding: 12px 24px;
    border-radius: 12px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.3s ease;
    border: none;
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}
.add-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(59, 130, 246, 0.4);
    color: white;
}
.sr-number {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #e2e8f0 0%, #cbd5e1 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    color: #475569;
    font-size: 13px;
}
.empty-state {
    text-align: center;
    padding: 60px 20px;
    color: #64748b;
}
.empty-icon {
    font-size: 64px;
    color: #cbd5e1;
    margin-bottom: 16px;
}
</style>

<div class="page-content">
    <div class="container-fluid">
        <div class="header-section">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="page-title">Form Fields</h1>
                    <p class="page-subtitle">Manage your dynamic form fields and configurations</p>
                </div>
                <a href="<?php echo e(route('form-fields.create')); ?>" class="add-btn">
                    <i class="fas fa-plus me-2"></i>Add New Field
                </a>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show border-0 shadow-sm mb-4" style="border-radius: 12px;">
                <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="modern-table">
            <table class="table mb-0">
                <thead>
                    <tr>
                        <th style="width: 80px;">#</th>
                        <th>Field Details</th>
                        <th>Type</th>
                        <th>Master Type</th>
                        <th>Parent Field</th>
                        <th style="width: 100px;">Options</th>
                        <th style="width: 120px;">Status</th>
                        <th style="width: 200px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $formFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="sr-number"><?php echo e($key + 1); ?></div>
                            </td>
                            <td>
                                <div class="field-name"><?php echo e($field->field_label); ?></div>
                                <div class="field-label"><?php echo e($field->field_name); ?></div>
                            </td>
                            <td>
                                <span class="modern-badge" style="background: <?php echo e($field->field_type == 'text' ? '#dbeafe' : 
                                    ($field->field_type == 'select' ? '#dcfce7' : 
                                    ($field->field_type == 'radio' ? '#fef3c7' : '#f3e8ff'))); ?>; color: <?php echo e($field->field_type == 'text' ? '#1e40af' : 
                                    ($field->field_type == 'select' ? '#166534' : 
                                    ($field->field_type == 'radio' ? '#92400e' : '#7c3aed'))); ?>;">
                                    <i class="fas fa-<?php echo e($field->field_type == 'text' ? 'font' : 
                                        ($field->field_type == 'select' ? 'list' : 
                                        ($field->field_type == 'radio' ? 'dot-circle' : 'check-square'))); ?> me-1"></i>
                                    <?php echo e(ucfirst($field->field_type)); ?>

                                </span>
                            </td>
                            <td>
                                <?php if($field->master_type): ?>
                                    <span class="modern-badge bg-<?php echo e($field->master_type == 'master' ? 'primary' : 'secondary'); ?> text-white">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $field->master_type))); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">—</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($field->parent_field_id): ?>
                                    <?php
                                        $parentField = \App\Models\FormField::find($field->parent_field_id);
                                    ?>
                                    <span class="text-primary" style="font-weight: 500;">
                                        <i class="fas fa-link me-1"></i>
                                        <?php echo e($parentField ? $parentField->field_label : 'Not Found'); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">—</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span class="badge bg-light text-dark rounded-pill px-3 py-2" style="font-weight: 600;">
                                        <?php echo e($field->options->count()); ?>

                                    </span>
                                </div>
                            </td>
                            <td>
                                <span class="modern-badge bg-<?php echo e($field->status ? 'success' : 'danger'); ?> text-white">
                                    <i class="fas fa-<?php echo e($field->status ? 'check' : 'times'); ?> me-1"></i>
                                    <?php echo e($field->status ? 'Active' : 'Inactive'); ?>

                                </span>
                            </td>
                            <td>
                                <div class="action-group">
                                    <a href="<?php echo e(route('form-fields.edit', $field)); ?>" class="action-btn btn-primary">
                                        <i class="fas fa-edit me-1"></i>Edit
                                    </a>
                                    <a href="<?php echo e(route('form-fields.options.index', $field)); ?>" class="action-btn btn-success">
                                        <i class="fas fa-cog me-1"></i>Options
                                    </a>
                                    <form method="POST" action="<?php echo e(route('form-fields.destroy', $field)); ?>" style="display:inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="action-btn btn-danger" onclick="return confirm('Are you sure you want to delete this field?')">
                                            <i class="fas fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8">
                                <div class="empty-state">
                                    <div class="empty-icon">
                                        <i class="fas fa-table"></i>
                                    </div>
                                    <h5 style="color: #64748b; font-weight: 600;">No form fields found</h5>
                                    <p>Get started by creating your first form field</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\carpet-overseas\resources\views/admin/master/form-fields/index.blade.php ENDPATH**/ ?>